/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.registry.impl;

import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.messageidentifier.WPCLMessageIdentifier;
import com.tandbergtv.workflow.adaptor.registry.IAdaptorRegistry;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.registry.IMessageRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class AdaptorRegistryImpl
implements IAdaptorRegistry {
    private IMessageRegistry messageRegistry;
    private static final Logger LOGGER = Logger.getLogger(AdaptorRegistryImpl.class);
    private final Map<String, IAdaptor> deviceRegistry = new HashMap<String, IAdaptor>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public AdaptorRegistryImpl(IMessageRegistry messageRegistry) {
        this.messageRegistry = messageRegistry;
    }

    @Override
    public IAdaptor getDeviceAdaptor(String deviceId) {
        IAdaptor adaptor = null;
        this.lock.readLock().lock();
        try {
            adaptor = this.deviceRegistry.get(deviceId);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return adaptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAdaptor getAdaptor(IAdaptorRequest request) {
        String deviceId = this.tryGetDeviceId(request);
        if (deviceId != null) {
            return this.getDeviceAdaptor(deviceId);
        }
        HashMap<String, IAdaptor> copy = null;
        this.lock.readLock().lock();
        try {
            copy = new HashMap<String, IAdaptor>(this.deviceRegistry);
        }
        finally {
            this.lock.readLock().unlock();
        }
        for (String key : copy.keySet()) {
            IAdaptor adaptor = (IAdaptor)copy.get(key);
            try {
                if (!adaptor.canDeliver(request)) continue;
                return adaptor;
            }
            catch (Exception e) {
                LOGGER.error((Object)("Failed to determine if adaptor[" + key + "] can deliver message."), (Throwable)e);
            }
        }
        throw new RuntimeException("No adaptor registered to process request.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDeviceAdaptor(String deviceSystemId, IAdaptor adaptor) {
        IAdaptor oldAdaptor = null;
        this.lock.writeLock().lock();
        try {
            oldAdaptor = this.deviceRegistry.put(deviceSystemId, adaptor);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.destroyAdaptor(deviceSystemId, oldAdaptor);
    }

    @Override
    public void unregisterDeviceAdaptor(String deviceSystemId) {
        IAdaptor adaptor = null;
        this.lock.writeLock().lock();
        try {
            adaptor = this.deviceRegistry.remove(deviceSystemId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.destroyAdaptor(deviceSystemId, adaptor);
    }

    private void destroyAdaptor(String key, IAdaptor adaptor) {
        try {
            if (adaptor != null) {
                adaptor.destroy();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Failure destroying adaptor[" + key + "]"), (Throwable)e);
        }
    }

    @Override
    public void clear() {
        HashMap<String, IAdaptor> copy = null;
        this.lock.writeLock().lock();
        try {
            copy = new HashMap<String, IAdaptor>(this.deviceRegistry);
            this.deviceRegistry.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        for (String key : copy.keySet()) {
            this.destroyAdaptor(key, (IAdaptor)copy.get(key));
        }
    }

    private String tryGetDeviceId(IAdaptorRequest request) {
        String systemId = null;
        try {
            WPCLMessageIdentifier identifier = new WPCLMessageIdentifier();
            IMessageUID uid = identifier.identify(request.getMessage());
            if (uid != null) {
                systemId = this.messageRegistry.getMessageDeviceID(uid.getUID());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return systemId;
    }
}

