/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.neptune;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;

public class ServiceLocator {
    private static final String DEFAULT_IP = "watchpoint-app";
    private static final String DEFAULT_IP_SSL = "https://app:8443";
    private static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final String WORKFLOW_CONF_DIR = "/conf/workflow";
    private static final String SERVICE_PROPERTIES = "/service.properties";
    private static final String NEPTUNE_BASE_URL = "neptune_base_url";

    public static String baseURL(boolean isUseSSLCert) {
        if (isUseSSLCert) {
            return DEFAULT_IP_SSL;
        }
        String baseUrl = ServiceLocator.getBaseURLFromConfig();
        if (baseUrl != null) {
            return baseUrl;
        }
        return "https://" + ServiceLocator.getBaseIPFromHostName() + ":8443";
    }

    public static URL getBaseURL(boolean isUseSSLCert) {
        try {
            return new URL(ServiceLocator.baseURL(isUseSSLCert));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getBaseURLFromConfig() {
        InputStream is = null;
        Properties prop = new Properties();
        try {
            File file = new File(System.getProperty(PRODUCT_DIR) + WORKFLOW_CONF_DIR, SERVICE_PROPERTIES);
            if (file.exists()) {
                is = new FileInputStream(file);
                prop.load(is);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return prop.getProperty(NEPTUNE_BASE_URL);
    }

    private static String getBaseIPFromHostName() {
        String ip = DEFAULT_IP;
        try {
            ip = InetAddress.getByName(DEFAULT_IP).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ip;
    }
}

