/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class Finder {
    private static final String QUERY = "select p.id from WorkflowProcess p where p.start < :date order by p.id desc";
    private static final String LATEST_RESOURCE_LOG_QUERY = "select count(*) from JBPM_LOG where TOKEN_ = :tokenId and LEAVE_ >= :date";
    private SessionFactory sessionFactory;

    public Finder(SessionFactory factory) {
        this.sessionFactory = factory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long findBefore(Date date) {
        try (Session session = null;){
            session = this.sessionFactory.openSession();
            Query query = session.createQuery(QUERY);
            query.setParameter("date", (Object)date).setMaxResults(1);
            Long id = (Long)query.uniqueResult();
            if (id != null) {
                long l = id;
                return l;
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> findUpdatedBetween(Date start, Date end) {
        try (Session session = null;){
            List list;
            session = this.sessionFactory.openSession();
            Criteria criteria = session.createCriteria(WorkflowProcess.class).add(Restrictions.between((String)"updateDate", (Object)start, (Object)end)).setProjection((Projection)Projections.property((String)"id"));
            List list2 = list = criteria.list();
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> findCompletedOrCancelledBetween(Date start, Date end) {
        try (Session session = null;){
            List list;
            session = this.sessionFactory.openSession();
            Criteria criteria = session.createCriteria(WorkflowProcess.class).add(Restrictions.between((String)"updateDate", (Object)start, (Object)end)).add(Restrictions.in((String)"status", (Object[])new ProcessStatus[]{ProcessStatus.CANCELLED, ProcessStatus.COMPLETED})).setProjection((Projection)Projections.property((String)"id"));
            List list2 = list = criteria.list();
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLogCountAfter(Long tokenId, Date start) {
        int count = 0;
        try (Session session = null;){
            session = this.sessionFactory.openSession();
            SQLQuery query = session.createSQLQuery(LATEST_RESOURCE_LOG_QUERY);
            query.setParameter("tokenId", (Object)tokenId);
            query.setParameter("date", (Object)start);
            count = ((Number)query.uniqueResult()).intValue();
        }
        return count;
    }
}

