/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.boot;

import com.tandbergtv.workflow.adaptor.IAdaptorService;
import com.tandbergtv.workflow.adaptor.internal.AdaptorService;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.lifecycle.Platform;
import com.tandbergtv.workflow.core.queue.Queue;
import com.tandbergtv.workflow.core.queue.monitor.IQueueMonitor;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.settings.ISettingsProvider;
import com.tandbergtv.workflow.core.settings.SettingsPluginLoader;
import com.tandbergtv.workflow.driver.message.queue.OffloadQueueProvider;
import com.tandbergtv.workflow.message.command.internal.CommandExecutor;
import com.tandbergtv.workflow.pluginmanager.PluginManagement;
import com.tandbergtv.workflow.pluginmanager.WatchPointPluginManager;
import com.tandbergtv.workflow.util.ApplicationProperties;
import java.lang.management.ManagementFactory;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;
import org.java.plugin.PluginManager;

public class Activator {
    private static final String MQ_MBEAN_NAME = "com.tandbergtv.watchpoint:type=Queue,name=mq";
    private static final String SETTING_GROUP = "com.tandbergtv.workflow.application";
    private static final String RETRY_SETTING_INTERVAL = "adaptor.retry.interval";
    private static final String RETRY_SETTING_MAX = "adaptor.retry.max";
    private static final Logger LOGGER = Logger.getLogger(Activator.class);

    public void start() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        CommandExecutor executor = new CommandExecutor();
        this.addService(executor);
        String dir = this.getOffloadQueueDir();
        OffloadQueueProvider provider = new OffloadQueueProvider(executor, dir);
        Queue queue = provider.createQueue();
        Service service = (Service)queue;
        registry.register(service.getServiceName(), service);
        DefaultMediator.getInstance().register((IColleague)IColleague.class.cast(queue));
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            StandardMBean mbean = new StandardMBean((IQueueMonitor)queue, IQueueMonitor.class);
            server.registerMBean(mbean, new ObjectName(MQ_MBEAN_NAME));
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Message offload queue monitoring will not be available", (Throwable)e);
        }
        PluginManager pluginManager = Platform.getPlatform().getPluginManager();
        this.addService((Service)new WatchPointPluginManager(pluginManager, Integer.MAX_VALUE));
        String retryInterval = null;
        String retryCount = null;
        ISettingsProvider settingsProvider = new SettingsPluginLoader().createSettingsProvider();
        if (settingsProvider != null) {
            Map<String, String> settings = settingsProvider.getProperties(SETTING_GROUP);
            retryInterval = settings.get(RETRY_SETTING_INTERVAL);
            retryCount = settings.get(RETRY_SETTING_MAX);
        }
        this.addService(new AdaptorService(retryInterval, retryCount));
    }

    public void stop() {
        this.removeService(IAdaptorService.class);
        this.removeService(PluginManagement.class);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.unregisterMBean(new ObjectName(MQ_MBEAN_NAME));
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Message offload queue MBean unregistration failed");
        }
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = registry.lookup("com.tandbergtv.workflow.mq");
        if (service != null) {
            DefaultMediator.getInstance().unregister((IColleague)IColleague.class.cast(service));
            service.stop();
            registry.unregister(service);
        }
        this.removeService(CommandExecutor.class);
    }

    private String getOffloadQueueDir() {
        String dir = null;
        try {
            dir = ApplicationProperties.getInstance().getProperty("install.dir");
        }
        catch (Exception e) {
            throw new RuntimeException("Application install directory is not configured", e);
        }
        return dir;
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = (Service)registry.lookup(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }
}

