/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util.resource;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.IInternalResourceService;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class InternalResourceService
implements IInternalResourceService {
    private Set<Long> resourceGroupIds;
    private Collection<String> systemIds;
    private static final Logger LOGGER = Logger.getLogger(InternalResourceService.class);

    public InternalResourceService(Collection<String> systemIds) {
        this.systemIds = systemIds;
    }

    public boolean needsResource(long resourceGroupId) {
        return !this.resourceGroupIds.contains(resourceGroupId);
    }

    public boolean isResourceQueuingDisabled(String systemId) {
        return this.systemIds.contains(systemId) || systemId.equals("04");
    }

    public void start() {
        this.resourceGroupIds = new HashSet<Long>();
        for (String systemId : this.systemIds) {
            this.buildResourceGroupList(systemId);
        }
        this.addResourceGroups();
    }

    public void stop() {
        this.resourceGroupIds.clear();
    }

    public String getServiceName() {
        return "resource-internal-service";
    }

    public void add(long resourceGroupId) {
        LOGGER.debug((Object)("Adding resourceGroupId : " + resourceGroupId));
        this.resourceGroupIds.add(resourceGroupId);
    }

    public void remove(long resourceGroupId) {
        LOGGER.debug((Object)("Removing resourceGroupId : " + resourceGroupId));
        this.resourceGroupIds.remove(resourceGroupId);
    }

    private void buildResourceGroupList(String systemID) {
        ResourceManagement service = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
        ResourceType resourceType = service.getResourceTypeBySystemId(systemID);
        if (resourceType == null) {
            return;
        }
        long resourceTypeId = resourceType.getId();
        List resourceGroups = service.getResourceGroupsByResourceType(resourceTypeId);
        for (ResourceGroup g : resourceGroups) {
            LOGGER.debug((Object)("for " + systemID + " added " + g.getName()));
            this.resourceGroupIds.add(g.getId());
        }
    }

    private void addResourceGroups() {
        ResourceManagement resourceManager = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
        List resourceGroups = resourceManager.getAllResourceGroups();
        for (ResourceGroup group : resourceGroups) {
            if (group.isAllocatable()) continue;
            this.resourceGroupIds.add(group.getId());
        }
    }
}

