/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.email;

import com.tandbergtv.workflow.core.ManualTaskNode;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.exe.email.IEmailService;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.taskmgmt.def.Task;

public abstract class AbstractTaskNotificationHandler
implements ActionHandler {
    private static final long serialVersionUID = 1240947962013470907L;
    private static final Logger LOGGER = Logger.getLogger(AbstractTaskNotificationHandler.class);
    private IEmailService emailService;

    public void execute(ExecutionContext executionContext) throws Exception {
        String addressList = null;
        try {
            List<Address> recipients = this.getRecipients(executionContext);
            if (recipients == null || recipients.isEmpty()) {
                return;
            }
            addressList = recipients.size() == 1 ? " to " + recipients.get(0).toString() : " to " + recipients.toString();
            this.getEmailService().send(recipients.toArray(new Address[recipients.size()]), this.getSubject(executionContext), this.getBody(executionContext));
        }
        catch (Throwable e) {
            LOGGER.warn((Object)("Failed to send email" + addressList), e);
        }
    }

    protected InitialContext getInitialContext(ExecutionContext context) throws NamingException {
        return new InitialContext();
    }

    protected Message createMessage(Session session) {
        return new MimeMessage(session);
    }

    protected abstract List<Address> getRecipients(ExecutionContext var1);

    protected abstract String getSubject(ExecutionContext var1);

    protected String getBody(ExecutionContext context) {
        String signature;
        StringBuilder body = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        body.append(this.getBodyMessage(context));
        body.append(lineSeparator);
        body.append(this.getTaskURL(context));
        String details = this.getTaskDetails(context);
        if (details != null && !details.isEmpty()) {
            body.append(lineSeparator);
            body.append(lineSeparator);
            body.append(this.getTaskDetails(context));
        }
        if ((signature = this.getBodySignature(context)) != null && !signature.isEmpty()) {
            body.append(lineSeparator);
            body.append(lineSeparator);
            body.append(signature);
        }
        body.append(lineSeparator);
        return body.toString();
    }

    protected abstract String getBodyMessage(ExecutionContext var1);

    protected abstract String getTaskURL(ExecutionContext var1);

    protected String getTaskDetails(ExecutionContext context) {
        String newLine = System.getProperty("line.separator");
        StringBuilder details = new StringBuilder();
        details.append(this.getBundle().getString("mail.task.details"));
        details.append(this.getProcessTaskDetails(context));
        String variableDetails = this.getVariableTaskDetails(context);
        if (variableDetails != null && !variableDetails.isEmpty()) {
            details.append(newLine);
            details.append(variableDetails);
        }
        return details.toString();
    }

    protected String getProcessTaskDetails(ExecutionContext context) {
        StringBuilder details = new StringBuilder();
        details.append(System.getProperty("line.separator"));
        String taskPattern = this.getBundle().getString("mail.task.details.taskName");
        String taskName = context.getToken().getNode().getName();
        details.append(MessageFormat.format(taskPattern, taskName));
        return details.toString();
    }

    protected String getVariableTaskDetails(ExecutionContext context) {
        Node currentNode = context.getToken().getNode();
        if (!(currentNode instanceof ManualTaskNode)) {
            return null;
        }
        ManualTaskNode manualTaskNode = (ManualTaskNode)currentNode;
        Set tasks = manualTaskNode.getTasks();
        if (tasks == null || tasks.isEmpty()) {
            return null;
        }
        StringBuilder details = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        String pattern = this.getBundle().getString("mail.task.details.variable");
        boolean first = true;
        Task task = (Task)tasks.iterator().next();
        List variableAccesses = task.getTaskController().getVariableAccesses();
        for (Object variableAccessObject : variableAccesses) {
            VariableAccess variableAccess = (VariableAccess)variableAccessObject;
            if (!variableAccess.isReadable()) continue;
            String displayName = variableAccess.getMappedName();
            Object value = context.getVariable(variableAccess.getVariableName());
            String valueString = value != null ? value.toString() : null;
            if (valueString == null || valueString.isEmpty()) continue;
            if (first) {
                first = false;
            } else {
                details.append(newLine);
            }
            details.append(MessageFormat.format(pattern, displayName, valueString));
        }
        return details.toString();
    }

    protected abstract String getBodySignature(ExecutionContext var1);

    protected void sendMessage(Message message) throws MessagingException {
        Transport.send((Message)message);
        LOGGER.debug((Object)("Sent email to: " + message.getRecipients(MimeMessage.RecipientType.TO)));
    }

    protected ResourceBundle getBundle() {
        String bundleName = this.getClass().getPackage().getName() + ".mail";
        return ResourceBundle.getBundle(bundleName);
    }

    private IEmailService getEmailService() {
        if (this.emailService == null) {
            this.emailService = (IEmailService)ServiceRegistry.getDefault().lookup(IEmailService.class);
        }
        return this.emailService;
    }

    public void setEmailService(IEmailService emailService) {
        this.emailService = emailService;
    }
}

