/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resource.sanity;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.tandbergtv.workflow.auth.IUserProvider;
import com.tandbergtv.workflow.auth.User;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resource.sanity.IHumanResourceSanityService;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.web.neptune.exception.NeptuneException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class HumanResourceSanityService
implements IHumanResourceSanityService {
    private static final Logger LOGGER = Logger.getLogger(HumanResourceSanityService.class);
    private ResourceManagement resourceManager;
    private IUserProvider userProvider;

    public String getServiceName() {
        return HumanResourceSanityService.class.getName();
    }

    public void start() {
    }

    public void stop() {
    }

    @Override
    public void checkAllHumanResources() {
        try {
            Map<String, User> users = this.getUsers();
            List resources = this.getResourceManager().getResourcesBySystemId("04");
            for (Resource r : resources) {
                try {
                    LOGGER.info((Object)("checking resource: " + r));
                    if (this.isUserQualifiedForResource(users, r)) continue;
                    this.invalidResource(r);
                }
                catch (Exception e) {
                    LOGGER.warn((Object)("error deleting resource" + r), (Throwable)e);
                }
            }
        }
        catch (NeptuneException e) {
            LOGGER.warn((Object)("cannot check human resource, error " + e.getLocalizedMessage()));
        }
    }

    private Map<String, User> getUsers() {
        return Maps.uniqueIndex((Iterable)this.userProvider.getUsersWithUserTaskPermissions(), (Function)new Function<User, String>(){

            public String apply(User input) {
                return input == null ? "" : input.getUserName();
            }
        });
    }

    private boolean isUserQualifiedForResource(Map<String, User> users, Resource r) {
        return users.containsKey(r.getUserName());
    }

    private void invalidResource(Resource r) throws Exception {
        if (r.getAdministrationState() == ResourceState.ONLINE) {
            this.getResourceManager().setResourceOffline(r.getId());
            LOGGER.info((Object)("take resource offline: " + r));
        }
    }

    private ResourceManagement getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
        }
        return this.resourceManager;
    }

    public void setUserProvider(IUserProvider userProvider) {
        this.userProvider = userProvider;
    }
}

