/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.coder;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.util.Watch;
import com.tandbergtv.workflow.driver.template.ITemplateCoder;
import com.tandbergtv.workflow.driver.template.ITemplateService;
import com.tandbergtv.workflow.driver.template.coder.TemplateNodeResourceBinder;
import com.tandbergtv.workflow.driver.template.coder.TemplateSerializerVersion;
import com.tandbergtv.workflow.driver.template.coder.TemplateVersionSerializer;
import com.tandbergtv.workflow.driver.template.coder.WorkflowTemplateWrapper;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.node.ProcessState;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectSerializer;

public class TemplateCoderBinaryImpl
implements ITemplateCoder {
    private static final Logger LOGGER = Logger.getLogger(TemplateCoderBinaryImpl.class);
    private static FSTConfiguration fstConf = FSTConfiguration.createDefaultConfiguration();
    private TemplateNodeResourceBinder nodeResourceBinder = TemplateNodeResourceBinder.get();
    private ITemplateService templateService;

    public String encode(WorkflowTemplate template) {
        this.nodeResourceBinder.cleanError();
        Stopwatch stopwatch = Stopwatch.createStarted();
        WorkflowTemplateWrapper templateWrapper = new WorkflowTemplateWrapper(template);
        templateWrapper.setResouceGroupNameInfo(this.loadResourceGroup());
        LinkedHashMap nodeMap = Maps.newLinkedHashMap();
        for (Node node : template.getAllNodes()) {
            if (!StringUtils.isNotBlank((String)node.getName())) continue;
            nodeMap.put(node.getName(), node);
        }
        templateWrapper.setNodes(nodeMap);
        templateWrapper.setTransitions(template.getAllTransition());
        this.nodeResourceBinder.removeTransitionNodeRefere(templateWrapper);
        byte[] data = fstConf.asByteArray((Object)templateWrapper);
        String content = Base64.getEncoder().encodeToString(data);
        this.nodeResourceBinder.rebindTransitionNodeRefere(templateWrapper);
        LOGGER.debug((Object)("Encode a Template object:[" + template + "] data size:" + data.length + " string size:" + content.length() + " in " + Watch.cost((Stopwatch)stopwatch)));
        return content;
    }

    protected Map<Long, String> loadResourceGroup() {
        return TemplateNodeResourceBinder.get().loadResourceGroupKeyToName();
    }

    public WorkflowTemplate decode(String content) {
        this.nodeResourceBinder.cleanError();
        Stopwatch stopwatch = Stopwatch.createStarted();
        byte[] data = Base64.getDecoder().decode(content);
        WorkflowTemplateWrapper templateWrapper = (WorkflowTemplateWrapper)fstConf.asObject(data);
        WorkflowTemplate template = templateWrapper.getTemplate();
        this.nodeResourceBinder.rebindTransitionNodeRefere(templateWrapper);
        this.nodeResourceBinder.rebuildNodeResource(template, templateWrapper.getResouceGroupNameInfo());
        this.rebindSubProcess(template);
        stopwatch.stop();
        LOGGER.debug((Object)("Decode a Template object:[" + template + "] in " + Watch.cost((Stopwatch)stopwatch)));
        return template;
    }

    private void rebindSubProcess(WorkflowTemplate template) {
        List subProcesses = template.getSubProcessRefers();
        if (subProcesses.isEmpty()) {
            return;
        }
        for (ProcessState sub : subProcesses) {
            if (sub.getSubProcessDefinition() == null) continue;
            String subProcessName = sub.getSubProcessDefinition().getName();
            WorkflowTemplate subTemplate = this.findTemplateService().getTemplateByName(subProcessName);
            sub.setSubProcessDefinition((ProcessDefinition)subTemplate);
            if (subTemplate != null) continue;
            String msg = "Cannot load sub process by " + subProcessName + " for Template[" + template.getFullName() + "]";
            LOGGER.error((Object)msg);
        }
    }

    public List<String> getErrors() {
        return Lists.newArrayList(this.nodeResourceBinder.getErrors());
    }

    public void setTemplateService(ITemplateService templateService) {
        this.templateService = templateService;
    }

    private ITemplateService findTemplateService() {
        if (this.templateService == null) {
            this.templateService = (ITemplateService)ServiceRegistry.getDefault().lookup(ITemplateService.class);
        }
        return this.templateService;
    }

    static {
        fstConf.registerSerializer(TemplateSerializerVersion.class, (FSTObjectSerializer)new TemplateVersionSerializer(), true);
    }
}

