/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.file;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.tandbergtv.workflow.log.LogDeserializer;
import com.tandbergtv.workflow.log.entities.MessageLog;
import com.tandbergtv.workflow.log.entities.ProcessStatusPerResourceLog;
import com.tandbergtv.workflow.log.file.FileLogReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.logging.log.ProcessLog;

public class LogReader {
    private static final Logger LOGGER = Logger.getLogger(LogReader.class);
    private String root;
    private final TransportClient client;
    private static final TimeValue TIMEOUT = TimeValue.timeValueSeconds((long)5L);
    private static final String TYPE_LOG = "log";
    private static final String PROCESS_ID = "processId";
    private static final String LOG_TYPE = "logType";
    private static final String NODE_ID = "nodeId";
    private static final String LOG_ID = "id";

    public LogReader(String root, TransportClient client) {
        this.root = root;
        this.client = client;
    }

    public LogReader(TransportClient client) {
        this.client = client;
    }

    public int count(long id, Class<? extends ProcessLog> type, Set<Long> nodeIds) {
        return this.count(id, Lists.newArrayList((Object[])new Class[]{type}), nodeIds);
    }

    public int count(long id, Collection<Class<? extends ProcessLog>> types, Set<Long> nodeIds) {
        try {
            SearchRequestBuilder bld = this.getSearchRequestBuilder(this.getBasicFilterCriteria(id, types, nodeIds));
            int count = (int)this.getSearchResponse(bld).getHits().totalHits();
            if (count == 0 && this.root != null) {
                return new FileLogReader(this.root).count(id, types, nodeIds);
            }
            return count;
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Failed to read logs from ES for process Id: " + id), (Throwable)e);
            return 0;
        }
    }

    public List<ProcessLog> getLogs(long id, Class<? extends ProcessLog> type) {
        return this.getLogs(id, Lists.newArrayList((Object[])new Class[]{type}));
    }

    public List<ProcessLog> getLogs(long id, Class<? extends ProcessLog> type, Set<Long> nodeIds, int start, int count, boolean descending) {
        return this.getLogs(id, Lists.newArrayList((Object[])new Class[]{type}), nodeIds, start, count, descending);
    }

    public List<ProcessLog> getLogs(long id, Collection<Class<? extends ProcessLog>> types) {
        try {
            BoolQueryBuilder filterBuilder = new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.termQuery((String)PROCESS_ID, (long)id)).must((QueryBuilder)new BoolQueryBuilder().should((QueryBuilder)QueryBuilders.termsQuery((String)LOG_TYPE, (String[])LogReader.getLogTypes(types))));
            SearchRequestBuilder bld = this.getSearchRequestBuilder((QueryBuilder)filterBuilder);
            bld = this.setSortCrtieria(LOG_ID, false, bld);
            List<ProcessLog> logs = this.getProcessLogs(bld);
            if (logs.isEmpty() && this.root != null) {
                return new FileLogReader(this.root).getLogs(id, types);
            }
            return logs;
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Failed to read logs from ES for process Id: " + id), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<ProcessLog> getLogs(long id, Collection<Class<? extends ProcessLog>> types, Set<Long> nodeIds, int start, int count, boolean descending) {
        try {
            SearchRequestBuilder bld = this.getSearchRequestBuilder(this.getBasicFilterCriteria(id, types, nodeIds));
            bld = this.setSortCrtieria(LOG_ID, descending, bld);
            bld.setFrom(start);
            bld.setSize(count);
            List<ProcessLog> logs = this.getProcessLogs(bld);
            if (logs.isEmpty() && this.root != null) {
                return new FileLogReader(this.root).getLogs(id, types, nodeIds, start, count, descending);
            }
            return logs;
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Failed to read logs from ES for process Id: " + id), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static String[] getLogTypes(Collection<Class<? extends ProcessLog>> types) {
        ArrayList<String> logTypes = new ArrayList<String>();
        for (Class<? extends ProcessLog> log : types) {
            if (NodeLog.class.isAssignableFrom(log)) {
                logTypes.add("nodeLog");
                continue;
            }
            if (MessageLog.class.isAssignableFrom(log)) {
                logTypes.add("messageLog");
                continue;
            }
            if (!ProcessStatusPerResourceLog.class.isAssignableFrom(log)) continue;
            logTypes.add("resourceLog");
        }
        return logTypes.toArray(new String[logTypes.size()]);
    }

    private Object[] getNodeIds(Set<Long> nodeIds) {
        return nodeIds.toArray(new Long[nodeIds.size()]);
    }

    private SearchRequestBuilder getRequestBuilder() {
        return this.client.prepareSearch(new String[0]).setTypes(new String[]{TYPE_LOG});
    }

    private QueryBuilder getBasicFilterCriteria(long id, Collection<Class<? extends ProcessLog>> types, Set<Long> nodeIds) {
        return new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.termQuery((String)PROCESS_ID, (long)id)).must((QueryBuilder)new BoolQueryBuilder().should((QueryBuilder)QueryBuilders.termsQuery((String)LOG_TYPE, (String[])LogReader.getLogTypes(types)))).must((QueryBuilder)new BoolQueryBuilder().should((QueryBuilder)QueryBuilders.termsQuery((String)NODE_ID, (Object[])this.getNodeIds(nodeIds))));
    }

    private SearchRequestBuilder getSearchRequestBuilder(QueryBuilder filterBuilder) {
        SearchRequestBuilder bld = this.getRequestBuilder();
        bld.setPostFilter(filterBuilder);
        return bld;
    }

    private SearchRequestBuilder setSortCrtieria(String sortField, boolean descending, SearchRequestBuilder bld) {
        FieldSortBuilder sort = SortBuilders.fieldSort((String)sortField);
        sort.order(descending ? SortOrder.DESC : SortOrder.ASC);
        sort.unmappedType("long");
        return bld.addSort((SortBuilder)sort);
    }

    private List<ProcessLog> getProcessLogs(SearchRequestBuilder bld) {
        return LogDeserializer.convert(this.getSearchResponse(bld).getHits().getHits());
    }

    private SearchResponse getSearchResponse(SearchRequestBuilder bld) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        SearchResponse resp = (SearchResponse)bld.execute().actionGet(TIMEOUT);
        stopwatch.stop();
        LOGGER.debug((Object)("actionGet: " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms. \n"));
        return resp;
    }
}

