/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.event;

import com.tandbergtv.workflow.core.event.ColleagueComparator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class AbstractMediator
implements IMediator {
    private Collection<WeakReference<IColleague>> references = new PriorityQueue<WeakReference<IColleague>>(10, new ColleagueComparator());
    private final ScheduledExecutorService executor = this.createExecutor("event-bus");
    private static final Logger LOGGER = Logger.getLogger(AbstractMediator.class);

    protected AbstractMediator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(IColleague colleague) {
        Collection<WeakReference<IColleague>> collection = this.references;
        synchronized (collection) {
            this.references.add(new WeakReference<IColleague>(colleague));
        }
        LOGGER.debug((Object)("Added " + colleague.getColleagueName() + " [" + this.references.size() + "]"));
        for (WeakReference<IColleague> reference : this.references) {
            IColleague c = (IColleague)reference.get();
            if (c == null) continue;
            LOGGER.debug((Object)("Colleague " + c.getColleagueName() + ", priority " + (Object)((Object)c.getColleaguePriority())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(IColleague colleague) {
        Collection<WeakReference<IColleague>> collection = this.references;
        synchronized (collection) {
            Iterator<WeakReference<IColleague>> i = this.references.iterator();
            while (i.hasNext()) {
                WeakReference<IColleague> reference = i.next();
                IColleague c = (IColleague)reference.get();
                if (c != null && c != colleague) continue;
                i.remove();
                LOGGER.debug((Object)("Removed colleague " + colleague.getColleagueName()));
            }
        }
    }

    @Override
    public void sendAsync(WorkflowEvent event) {
        this.send(event, true);
    }

    @Override
    public void send(WorkflowEvent event) {
        this.send(event, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(WorkflowEvent event, boolean isAsync) {
        ArrayList<WeakReference<IColleague>> copy = null;
        Iterator<WeakReference<IColleague>> i = null;
        Collection<WeakReference<IColleague>> collection = this.references;
        synchronized (collection) {
            copy = new ArrayList<WeakReference<IColleague>>();
            i = this.references.iterator();
            while (i.hasNext()) {
                WeakReference<IColleague> reference = i.next();
                IColleague colleague = (IColleague)reference.get();
                if (colleague == null) {
                    i.remove();
                    LOGGER.debug((Object)"Removed colleague");
                    continue;
                }
                copy.add(reference);
            }
        }
        for (WeakReference<IColleague> reference : copy) {
            IColleague colleague = (IColleague)reference.get();
            if (colleague == null) continue;
            if (isAsync) {
                this.sendAsync(colleague, event);
                continue;
            }
            this.send(colleague, event);
        }
    }

    private void sendAsync(final IColleague colleague, final WorkflowEvent event) {
        ScheduledExecutorService ses = this.getExecutor(event);
        ses.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    long t = System.currentTimeMillis();
                    colleague.receive(event);
                    long delta = System.currentTimeMillis() - t;
                    if (delta > 30000L) {
                        String name = colleague.getColleagueName();
                        String e = event.getClass().getSimpleName();
                        LOGGER.warn((Object)(String.valueOf(name) + " took " + delta / 1000L + " sec for " + e));
                    }
                }
                catch (Throwable t) {
                    String name = colleague.getColleagueName();
                    LOGGER.debug((Object)("Failed to send " + event.getClass().getSimpleName() + " to " + name), t);
                }
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    private void send(IColleague colleague, WorkflowEvent event) {
        try {
            colleague.receive(event);
        }
        catch (Throwable t) {
            String name = colleague.getColleagueName();
            LOGGER.debug((Object)("Failed to send " + event.getClass().getSimpleName() + " to " + name), t);
        }
    }

    private ScheduledExecutorService getExecutor(WorkflowEvent event) {
        return this.executor;
    }

    private ScheduledExecutorService createExecutor(final String name) {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setName(name);
                t.setDaemon(true);
                return t;
            }
        });
        return executor;
    }
}

