/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message;

import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.ISource;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.DefaultMessageKeyGenerator;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.jbpm.graph.exe.ExecutionContext;

public class WorkflowMessageFactory {
    private static final String PROTOCOL = "http://";
    private static final String SERVICE_PATH = "/workflow/services/AdaptorService";
    private static final String HOSTNAME = "watchpoint-app";
    private static final String SOURCE = "WFS";
    private static final Integer PORT = 7070;

    private static WorkflowMessageFactory newInstance() {
        return new WorkflowMessageFactory();
    }

    public static WorkflowMessage createControlMessage(String uid) {
        return WorkflowMessageFactory.newInstance().createControlMessageImpl(uid);
    }

    public static WorkflowMessage createControlMessage(String uid, ExecutionContext ec) {
        return WorkflowMessageFactory.newInstance().createControlMessageImpl(uid, ec);
    }

    public static WorkflowMessage createAckMessage(WorkflowMessage message) {
        return WorkflowMessageFactory.newInstance().createWorkflowMessageImpl(message.getMessageUID(), message.getKey(), WorkflowMessage.MessageType.ack);
    }

    public static WorkflowMessage createNackMessage(WorkflowMessage message) {
        return WorkflowMessageFactory.newInstance().createWorkflowMessageImpl(message.getMessageUID(), message.getKey(), WorkflowMessage.MessageType.nack);
    }

    protected WorkflowMessage createControlMessageImpl(String uid) {
        MessageUIDImpl messageUid = new MessageUIDImpl(uid);
        WorkflowMessage message = this.createWorkflowMessageImpl(messageUid, null, null, WorkflowMessage.MessageType.control);
        message.setResponseDestination(this.createResponseDestination());
        return message;
    }

    protected WorkflowMessage createControlMessageImpl(String uid, ExecutionContext ec) {
        IMessageKey key = this.createMessageKey(ec);
        MessageUIDImpl messageUid = new MessageUIDImpl(uid);
        IMessageKey origin = this.createOrigin(ec);
        WorkflowMessage message = this.createWorkflowMessageImpl(messageUid, key, origin, WorkflowMessage.MessageType.control);
        message.setResponseDestination(this.createResponseDestination());
        return message;
    }

    protected WorkflowMessage createWorkflowMessageImpl(IMessageUID uid, IMessageKey key, WorkflowMessage.MessageType type) {
        WorkflowMessage message = new WorkflowMessage(uid, key, type);
        message.setSource(this.createSource());
        return message;
    }

    protected WorkflowMessage createWorkflowMessageImpl(IMessageUID uid, IMessageKey key, IMessageKey origin, WorkflowMessage.MessageType type) {
        WorkflowMessage message = new WorkflowMessage(uid, key, origin, type);
        message.setSource(this.createSource());
        return message;
    }

    private ISource createSource() {
        return new HTTPDevice(this.url(), SOURCE);
    }

    private IDestination createResponseDestination() {
        return new HTTPDevice(this.url());
    }

    private IMessageKey createMessageKey(ExecutionContext ec) {
        DefaultMessageKeyGenerator keyGenStrategy = new DefaultMessageKeyGenerator();
        IMessageKey key = keyGenStrategy.generate(ec.getToken());
        return key;
    }

    private IMessageKey createOrigin(ExecutionContext ec) {
        DefaultMessageKeyGenerator keyGenStrategy = new DefaultMessageKeyGenerator();
        IMessageKey key = keyGenStrategy.generateOrigin(ec.getToken());
        return key;
    }

    private String url() {
        return PROTOCOL + this.resolve(HOSTNAME) + ":" + PORT + SERVICE_PATH;
    }

    private String resolve(String hostname) {
        String addr = null;
        try {
            addr = InetAddress.getByName(hostname).getHostAddress();
        }
        catch (IOException e) {
            List<String> addresses = this.getHostAddresses();
            if (addresses.isEmpty()) {
                throw new RuntimeException("No IP addresses configured");
            }
            addr = addresses.get(0);
        }
        return addr;
    }

    private List<String> getHostAddresses() {
        ArrayList<String> addresses = new ArrayList<String>();
        try {
            InetAddress localhost = InetAddress.getByName("localhost");
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress ip = ips.nextElement();
                    if (ip instanceof Inet6Address || ip.getHostAddress().equals(localhost.getHostAddress())) continue;
                    addresses.add(ip.getHostAddress());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return addresses;
    }
}

