/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.internal;

import com.tandbergtv.workflow.monitor.core.Metric;
import com.tandbergtv.workflow.monitor.internal.FileRecorderProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileSystemArchiver {
    private final File root;
    private long period;

    public FileSystemArchiver(File root, long period) {
        this.root = root;
        this.period = period;
    }

    public void archive(Collection<Metric> metrics) throws IOException {
        if (metrics == null || metrics.isEmpty()) {
            return;
        }
        File dir = FileRecorderProperties.directoryFor(this.root, metrics.iterator().next());
        File zip = new File(dir, this.namePattern());
        Collection<File> files = this.getFilesToArchive(dir, this.getDomains(metrics));
        if (files.isEmpty()) {
            return;
        }
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zip));
        this.doArchive(zos, files);
        zos.close();
        for (File file : files) {
            file.delete();
        }
    }

    private void doArchive(ZipOutputStream zos, Collection<File> files) throws IOException {
        for (File file : files) {
            this.doArchive(zos, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doArchive(ZipOutputStream out, File file) throws IOException {
        byte[] buf = new byte[4096];
        FileInputStream is = null;
        try {
            int count;
            is = new FileInputStream(file);
            out.putNextEntry(new ZipEntry(file.getName()));
            while ((count = is.read(buf)) > 0) {
                out.write(buf, 0, count);
            }
            out.closeEntry();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private Collection<File> getFilesToArchive(File dir, Collection<String> prefixes) {
        HashSet<File> files = new HashSet<File>();
        for (File file : dir.listFiles()) {
            for (String prefix : prefixes) {
                if (!file.getName().startsWith(prefix) || System.currentTimeMillis() - file.lastModified() <= this.period) continue;
                files.add(file);
            }
        }
        return files;
    }

    private Set<String> getDomains(Collection<Metric> metrics) {
        HashSet<String> set = new HashSet<String>();
        for (Metric metric : metrics) {
            set.add(metric.getDomain());
        }
        return set;
    }

    private String namePattern() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd_HHmm");
        String time = formatter.format(new Date());
        return time + ".zip";
    }
}

