/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tandbergtv.workflow.auth.domain.IProtectionKeyAware;
import com.tandbergtv.workflow.auth.domain.ProtectionKey;
import com.tandbergtv.workflow.core.AutomaticTaskNode;
import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.DatatypeConverter;
import com.tandbergtv.workflow.core.ExtendedFileDefinition;
import com.tandbergtv.workflow.core.GraphElementAnnotation;
import com.tandbergtv.workflow.core.NodeGroup;
import com.tandbergtv.workflow.core.Selector;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.TypeConversionException;
import com.tandbergtv.workflow.core.graph.DefaultExceptionHandler;
import com.tandbergtv.workflow.core.graph.ExtendedTransition;
import com.tandbergtv.workflow.core.graph.Graph;
import com.tandbergtv.workflow.core.graph.IAnnotatedElement;
import com.tandbergtv.workflow.core.graph.Loop;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.jbpm.file.def.FileDefinition;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.def.ExceptionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.NodeCollection;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.node.Fork;
import org.jbpm.graph.node.Join;
import org.jbpm.graph.node.ProcessState;
import org.jbpm.graph.node.StartState;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;
import org.jbpm.module.def.ModuleDefinition;
import org.jbpm.taskmgmt.def.Task;

public class WorkflowTemplate
extends ProcessDefinition
implements Graph,
IProtectionKeyAware,
IAnnotatedElement,
Parsable {
    public static final String NAME_SEPARATOR = " - v";
    private static final long serialVersionUID = 5496751233335662922L;
    private long id;
    private Set<ProtectionKey> protectionKeys = new HashSet<ProtectionKey>();
    private Set<Selector> selectorKeys = new HashSet<Selector>();
    private Date createDate;
    private static final String ANNOTATION_PREFIX = "@";
    private transient boolean isActive = true;

    public WorkflowTemplate() {
    }

    public WorkflowTemplate(String name) {
        super(name);
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    @Override
    public Set<ProtectionKey> getProtectionKeys() {
        return this.protectionKeys;
    }

    public void setProtectionKeys(Set<ProtectionKey> protectionKeys) {
        this.protectionKeys = protectionKeys;
    }

    @Override
    public void addProtectionKey(ProtectionKey protectionKey) {
        this.protectionKeys.add(protectionKey);
    }

    public ModuleDefinition addDefinition(ModuleDefinition moduleDefinition) {
        try {
            Field field = ModuleDefinition.class.getDeclaredField("name");
            field.setAccessible(true);
            field.set(moduleDefinition, moduleDefinition.getClass().getName());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return super.addDefinition(moduleDefinition);
    }

    public List<Node> getNodes() {
        return super.getNodes();
    }

    public FileDefinition getFileDefinition() {
        ExtendedFileDefinition definition = new ExtendedFileDefinition();
        definition.setProcessDefinition(this);
        return definition;
    }

    public String getFullName() {
        return this.name + NAME_SEPARATOR + this.version;
    }

    public boolean hasAsyncMessages() {
        return this.hasAsyncMessages((NodeCollection)this);
    }

    private boolean hasAsyncMessages(NodeCollection parent) {
        for (Object child : parent.getNodes()) {
            AutomaticTaskNode tasknode;
            if (child instanceof NodeCollection) {
                return this.hasAsyncMessages((NodeCollection)child);
            }
            if (!(child instanceof AutomaticTaskNode) || (tasknode = (AutomaticTaskNode)AutomaticTaskNode.class.cast(child)).getMessage() == null) continue;
            return true;
        }
        return false;
    }

    public Collection<TaskVariable> getStartTaskVariables() {
        Task task = this.getTaskMgmtDefinition().getStartTask();
        if (task == null) {
            return Collections.emptyList();
        }
        return task.getTaskController().getVariableAccesses();
    }

    public void setStartTaskVariables(Map<String, Object> parameters) throws TypeConversionException {
        this.checkValues(parameters);
        for (TaskVariable variable : this.getStartTaskVariables()) {
            Object value = parameters.get(variable.getVariableName());
            String currentValue = value != null ? value.toString() : null;
            variable.setInitialValue(currentValue);
        }
    }

    public boolean hasStartVariable(String variableName, Datatype type) {
        for (TaskVariable variable : this.getStartTaskVariables()) {
            if (!variable.getVariableName().equals(variableName) || !type.equals((Object)variable.getDatatype())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void depthFirstTraversal(NodeVisitor visitor) {
        HashMap<Node, Boolean> traversed = new HashMap<Node, Boolean>();
        Queue<Node> roots = this.getRoots();
        for (Node root : roots) {
            this.depthFirstTraversal(root, traversed, visitor);
        }
    }

    private void depthFirstTraversal(Node node, Map<Node, Boolean> traversed, NodeVisitor visitor) {
        traversed.put(node, true);
        if (!(node instanceof Loop)) {
            visitor.visit(node);
        } else {
            Node first = ((Loop)((Object)Loop.class.cast(node))).first();
            this.depthFirstTraversal(first, traversed, visitor);
        }
        List transitions = node.getLeavingTransitions();
        if (transitions == null) {
            return;
        }
        for (Transition t : transitions) {
            Boolean visited;
            Node destination = t.getTo();
            if (destination == null) continue;
            if (destination.getSuperState() instanceof NodeGroup) {
                destination = destination.getSuperState();
            }
            if (Boolean.TRUE.equals(visited = traversed.get(destination))) continue;
            this.depthFirstTraversal(destination, traversed, visitor);
        }
    }

    public void greedyBreadthFirstTraversal(NodeVisitor visitor) {
        LinkedList<Node> queue = new LinkedList<Node>();
        HashMap<Node, Boolean> traversed = new HashMap<Node, Boolean>();
        Queue<Node> roots = this.getRoots();
        for (Node root : roots) {
            queue.add(root);
        }
        while (!queue.isEmpty()) {
            List transitions;
            Node node = (Node)queue.remove(0);
            traversed.put(node, true);
            visitor.visit(node);
            if (node instanceof Fork) {
                this.greedyDepthFirstTraversal(node, queue, traversed, visitor);
                continue;
            }
            if (node instanceof Loop) {
                Node first = ((Loop)((Object)Loop.class.cast(node))).first();
                this.greedyDepthFirstTraversal(first, queue, traversed, visitor);
                Node destination = node.getDefaultLeavingTransition().getTo();
                if (destination != null && destination.getSuperState() instanceof NodeGroup) {
                    destination = destination.getSuperState();
                }
                traversed.put(destination, true);
                queue.add(destination);
                continue;
            }
            if (node instanceof SuperState) {
                this.iterateSuperState(node, queue, traversed, visitor);
            }
            if ((transitions = node.getLeavingTransitions()) == null) continue;
            for (Transition transition : transitions) {
                Boolean visited;
                Node destination = transition.getTo();
                if (destination == null) continue;
                if (destination.getSuperState() instanceof NodeGroup) {
                    destination = destination.getSuperState();
                }
                if (Boolean.TRUE.equals(visited = (Boolean)traversed.get(destination))) continue;
                traversed.put(destination, true);
                queue.add(destination);
            }
        }
    }

    private void iterateSuperState(Node node, List<Node> queue, Map<Node, Boolean> traversed, NodeVisitor visitor) {
        SuperState superState = (SuperState)SuperState.class.cast(node);
        for (Object child : superState.getNodes()) {
            visitor.visit((Node)child);
            if (!(child instanceof Loop)) continue;
            Node first = ((Loop)((Object)Loop.class.cast(child))).first();
            this.greedyDepthFirstTraversal(first, queue, traversed, visitor);
        }
    }

    private void greedyDepthFirstTraversal(Node node, List<Node> queue, Map<Node, Boolean> traversed, NodeVisitor visitor) {
        if (node == null) {
            return;
        }
        Node vistedNode = node;
        if (node instanceof SuperState) {
            this.iterateSuperState(node, queue, traversed, visitor);
        }
        if (vistedNode instanceof Loop) {
            Node first = ((Loop)((Object)Loop.class.cast(node))).first();
            this.greedyDepthFirstTraversal(first, queue, traversed, visitor);
            vistedNode = vistedNode.getDefaultLeavingTransition().getTo();
            if (vistedNode != null && vistedNode.getSuperState() instanceof NodeGroup) {
                vistedNode = node.getSuperState();
            }
        }
        if (vistedNode instanceof Join) {
            if (!queue.contains(node)) {
                queue.add(0, node);
            }
            return;
        }
        traversed.put(vistedNode, true);
        visitor.visit(vistedNode);
        List transitions = vistedNode.getLeavingTransitions();
        if (transitions == null) {
            return;
        }
        for (Transition t : transitions) {
            Boolean visited;
            Node destination = t.getTo();
            if (destination != null && destination.getSuperState() instanceof NodeGroup) {
                destination = destination.getSuperState();
            }
            if (Boolean.TRUE.equals(visited = traversed.get(destination))) continue;
            this.greedyDepthFirstTraversal(destination, queue, traversed, visitor);
        }
    }

    @Override
    public void breadthFirstTraversal(NodeVisitor visitor) {
        LinkedList<Node> queue = new LinkedList<Node>();
        HashMap<Node, Boolean> traversed = new HashMap<Node, Boolean>();
        Node root = this.getStartState();
        traversed.put(root, true);
        queue.add(root);
        while (!queue.isEmpty()) {
            Node node = (Node)queue.remove(0);
            if (node instanceof Fork) {
                this.depthFirstTraversal2(node, queue, traversed, visitor);
                continue;
            }
            if (node instanceof Loop) {
                Node first = ((Loop)((Object)Loop.class.cast(node))).first();
                this.depthFirstTraversal2(first, queue, traversed, visitor);
                Node destination = node.getDefaultLeavingTransition().getTo();
                if (destination.getSuperState() instanceof NodeGroup) {
                    destination = destination.getSuperState();
                }
                traversed.put(destination, true);
                queue.add(destination);
                continue;
            }
            visitor.visit(node);
            List transitions = node.getLeavingTransitions();
            if (transitions == null) continue;
            for (Transition transition : transitions) {
                Boolean visited;
                Node destination = transition.getTo();
                if (destination.getSuperState() instanceof NodeGroup) {
                    destination = destination.getSuperState();
                }
                if (Boolean.TRUE.equals(visited = (Boolean)traversed.get(destination))) continue;
                traversed.put(destination, true);
                queue.add(destination);
            }
        }
    }

    private void depthFirstTraversal2(Node node, List<Node> queue, Map<Node, Boolean> traversed, NodeVisitor visitor) {
        if (node instanceof Loop) {
            Node first = ((Loop)((Object)Loop.class.cast(node))).first();
            this.depthFirstTraversal2(first, queue, traversed, visitor);
            node = node.getDefaultLeavingTransition().getTo();
            if (node.getSuperState() instanceof NodeGroup) {
                node = node.getSuperState();
            }
        }
        if (node instanceof Join) {
            if (!queue.contains(node)) {
                queue.add(0, node);
            }
            return;
        }
        traversed.put(node, true);
        visitor.visit(node);
        List transitions = node.getLeavingTransitions();
        if (transitions == null) {
            return;
        }
        for (Transition t : transitions) {
            Boolean visited;
            Node destination = t.getTo();
            if (destination.getSuperState() instanceof NodeGroup) {
                destination = destination.getSuperState();
            }
            if (Boolean.TRUE.equals(visited = traversed.get(destination))) continue;
            this.depthFirstTraversal2(destination, queue, traversed, visitor);
        }
    }

    @Override
    public Queue<Node> getRoots() {
        LinkedList<Node> roots = new LinkedList<Node>();
        roots.add(this.getStartState());
        for (Node node : this.nodes) {
            Set transitions;
            if (node instanceof StartState || (transitions = node.getArrivingTransitions()) != null && !transitions.isEmpty()) continue;
            roots.add(node);
        }
        return roots;
    }

    public Set<Selector> getSelectorKeys() {
        return this.selectorKeys;
    }

    public void addSelectorKey(Selector selector) {
        selector.setTemplate(this);
        this.selectorKeys.add(selector);
    }

    public void removeSelectorKey(Selector selector) {
        this.selectorKeys.remove(selector);
    }

    public void removeSelectorKeys() {
        this.selectorKeys.clear();
    }

    public void raiseException(Throwable exception, ExecutionContext context) throws DelegationException {
        if (this.exceptionHandlers == null || this.exceptionHandlers.isEmpty()) {
            this.addExceptionHandler(new DefaultExceptionHandler());
        }
        try {
            ExceptionHandler exceptionHandler = this.findExceptionHandler(exception);
            if (exceptionHandler != null) {
                context.setException(exception);
                exceptionHandler.handleException(context);
            }
        }
        catch (Throwable t) {
            throw new DelegationException(t, context);
        }
    }

    public void read(Element root, JpdlXmlReader jpdlReader) {
        Element e = root.element("description");
        if (e == null) {
            return;
        }
        Matcher m = Pattern.compile("\\@.*\\(.*\\)").matcher(e.getText());
        while (m.find()) {
            this.addAnnotation(m.group().trim());
        }
    }

    public void write(Element element) {
    }

    @Override
    public Collection<String> getAnnotations() {
        ArrayList<String> annotations = new ArrayList<String>();
        if (!this.hasActions()) {
            return annotations;
        }
        for (Action action : this.actions.values()) {
            if (!(action instanceof GraphElementAnnotation)) continue;
            String type = ((GraphElementAnnotation)((Object)GraphElementAnnotation.class.cast(action))).getAnnotation();
            annotations.add(type);
        }
        return annotations;
    }

    @Override
    public Collection<String> getAnnotations(String annotationType) {
        ArrayList<String> annotations = new ArrayList<String>();
        if (!this.hasActions()) {
            return annotations;
        }
        for (Action action : this.actions.values()) {
            String type;
            if (!(action instanceof GraphElementAnnotation) || !(type = ((GraphElementAnnotation)((Object)GraphElementAnnotation.class.cast(action))).getAnnotation()).startsWith(ANNOTATION_PREFIX + annotationType + "(")) continue;
            annotations.add(type);
        }
        return annotations;
    }

    protected void addAnnotation(String annotation) {
        this.addAction((Action)new GraphElementAnnotation(annotation));
    }

    protected void checkValues(Map<String, Object> parameters) throws TypeConversionException {
        for (TaskVariable variable : this.getStartTaskVariables()) {
            Object value = parameters.get(variable.getVariableName());
            if (!StringUtils.isNotBlank((String)Objects.toString(value, ""))) continue;
            new DatatypeConverter().convert(value, variable.getDatatype());
        }
    }

    public boolean equals(Object o) {
        if (o instanceof WorkflowTemplate) {
            return this.getId() == ((WorkflowTemplate)WorkflowTemplate.class.cast(o)).getId();
        }
        return false;
    }

    public List<Node> getAllNodes() {
        final LinkedHashSet nodes = new LinkedHashSet();
        this.greedyBreadthFirstTraversal(new NodeVisitor(){

            @Override
            public void visit(Node node) {
                nodes.add(node);
            }
        });
        return Lists.newArrayList(nodes);
    }

    public int hashCode() {
        return Long.valueOf(this.getId()).hashCode();
    }

    public String toString() {
        return this.isNew() ? this.getFullName() : "[" + this.getId() + "] " + this.getFullName();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public boolean isNew() {
        return this.getId() <= 0L;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public boolean hasSubProcess() {
        return !this.getSubProcessRefers().isEmpty();
    }

    public List<ProcessState> getSubProcessRefers() {
        final LinkedHashSet subProcesses = Sets.newLinkedHashSet();
        this.greedyBreadthFirstTraversal(new NodeVisitor(){

            @Override
            public void visit(Node node) {
                if (node instanceof ProcessState) {
                    subProcesses.add((ProcessState)node);
                }
            }
        });
        return Lists.newArrayList((Iterable)subProcesses);
    }

    public List<ExtendedTransition> getAllTransition() {
        final LinkedHashSet allTranstions = Sets.newLinkedHashSet();
        this.greedyBreadthFirstTraversal(new NodeVisitor(){

            @Override
            public void visit(Node node) {
                if (node.getArrivingTransitions() != null) {
                    this.addTransition(node.getArrivingTransitions());
                }
                if (node.getLeavingTransitions() != null) {
                    this.addTransition(node.getLeavingTransitions());
                }
            }

            void addTransition(Collection transitions) {
                for (Object obj : transitions) {
                    ExtendedTransition transition = (ExtendedTransition)((Object)obj);
                    allTranstions.add(transition);
                }
            }
        });
        return Lists.newArrayList((Iterable)allTranstions);
    }
}

