/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.util;

import com.google.common.base.Stopwatch;
import com.tandbergtv.workflow.core.WFSearchResult;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.springframework.util.CollectionUtils;

public class Watch {
    private Watch() {
    }

    public static String cost(Stopwatch watch) {
        if (watch.isRunning()) {
            watch.stop();
        }
        return watch.elapsed(TimeUnit.MILLISECONDS) + " ms";
    }

    public static <K, V> String toString(Map<K, V> map) {
        if (CollectionUtils.isEmpty(map)) {
            return " Null Map";
        }
        StringBuilder sBuilder = new StringBuilder("{");
        for (Map.Entry<K, V> entry : map.entrySet()) {
            sBuilder.append(",");
            sBuilder.append(ReflectionToStringBuilder.toString(entry));
        }
        sBuilder.append("}");
        return ReflectionToStringBuilder.toString(map);
    }

    public static <V> String toString(List<V> list) {
        if (CollectionUtils.isEmpty(list)) {
            return " Null List";
        }
        StringBuilder sBuilder = new StringBuilder("[");
        for (V v : list) {
            sBuilder.append(",");
            sBuilder.append(ReflectionToStringBuilder.toString(v));
        }
        sBuilder.append("]");
        return sBuilder.toString();
    }

    public static String toString(WFSearchResult result) {
        return result != null ? result.getProcessId() + ">>" + ReflectionToStringBuilder.toString((Object)result) : null;
    }
}

