/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template;

import com.google.common.base.Throwables;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.internal.ReplicatedSimpleCache;
import com.tandbergtv.workflow.driver.template.TemplateReaderException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class TemplateCache
extends ReplicatedSimpleCache<WorkflowTemplate> {
    private static final Logger LOGGER = Logger.getLogger(TemplateCache.class);

    public TemplateCache(ResourceBundle bundle) {
        super(TemplateCache.getServiceName(bundle), Integer.parseInt(bundle.getString("template.cache.size")), null);
    }

    private static String getServiceName(ResourceBundle bundle) {
        return bundle.getString("template.cache.name");
    }

    public TemplateCache(String name, int size) {
        super(name, size);
    }

    public static TemplateCache createTemplateCache() {
        ResourceBundle bundle = ResourceBundle.getBundle(TemplateCache.class.getPackage().getName() + ".service");
        return new TemplateCache(bundle);
    }

    public static String getDefaultServiceName() {
        ResourceBundle bundle = ResourceBundle.getBundle(TemplateCache.class.getPackage().getName() + ".service");
        return TemplateCache.getServiceName(bundle);
    }

    public void cache(WorkflowTemplate template, boolean notify) {
        LOGGER.debug((Object)("Adding to cache " + template));
        try {
            LOGGER.debug((Object)("Reloading template to local cache:  " + template.getId()));
            this.add(Long.valueOf(template.getId()), template, notify);
        }
        catch (StackOverflowError e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            LOGGER.error((Object)"Fail to add the template into cache:", rootCause);
            throw new TemplateReaderException("Fail to add the template into cache:", rootCause);
        }
    }

    public void uncache(WorkflowTemplate template) {
        LOGGER.debug((Object)("Removing template from local cache: " + template.getId()));
        this.remove(Long.valueOf(template.getId()));
    }
}

