/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.hazelcast.core.IMap;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class HazelcastNodeIdFinder {
    public static final String WORKFLOW_NODE_ID_MAP = "wfs_hz_nodeId";
    private static final Logger logger = Logger.getLogger(HazelcastNodeIdFinder.class);

    public static String getNodeId() {
        String nodeId = null;
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            IMap idSet = HazelcastNodeIdFinder.getClusterService().getInstance().getMap(WORKFLOW_NODE_ID_MAP);
            if (idSet.containsKey((Object)hostname)) {
                nodeId = (String)idSet.get((Object)hostname);
            } else {
                nodeId = String.valueOf(HazelcastNodeIdFinder.getClusterService().getInstance().getAtomicLong("NodeId").addAndGet(1L));
                idSet.put((Object)hostname, (Object)nodeId);
            }
        }
        catch (UnknownHostException e) {
            logger.error((Object)"Cannot find hostname for current App node:", (Throwable)e);
        }
        logger.debug((Object)("Get assigned node id : " + nodeId));
        return nodeId;
    }

    private static IClusterService getClusterService() {
        return (IClusterService)ServiceRegistry.getDefault().lookup(IClusterService.class);
    }
}

