/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowProcessNote;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.internal.callable.TokenCallable;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;

public class SaveProcessCallable
extends TokenCallable {
    private String processNotesText;
    private ProcessPriority priority;
    private static final long serialVersionUID = -6904521560817110981L;

    public SaveProcessCallable(CustomToken token, ProcessPriority priority, String processNotesText) {
        super(token);
        this.processNotesText = processNotesText;
        this.priority = priority;
    }

    @Override
    public CustomToken call() throws Exception {
        CustomToken token = this.findToken();
        WorkflowProcess process = token.getProcessInstance();
        ServiceRegistry registry = ServiceRegistry.getDefault();
        if (this.priority != process.getPriority()) {
            ((IProcessManagerService)registry.lookup(IProcessManagerService.class)).setPriority(process, this.priority);
        }
        if (StringUtils.isNotBlank((String)this.processNotesText)) {
            WorkflowProcessNote note = process.getNote();
            if (note == null) {
                note = new WorkflowProcessNote();
                process.setNote(note);
            }
            note.appendNotes(this.processNotesText);
        }
        ((IPersistenceService)registry.lookup(IPersistenceService.class)).save(process);
        return token;
    }

    @Override
    protected Callable<CustomToken> innerCallable(CustomToken token) {
        throw new UnsupportedOperationException();
    }
}

