/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template;

import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.TypeConversionException;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.entity.TemplateContentTypeEnum;
import com.tandbergtv.workflow.core.entity.WorkflowTemplateDTO;
import com.tandbergtv.workflow.core.entity.WorkflowTemplateTypeId;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.util.JsonObjectMapper;
import com.tandbergtv.workflow.driver.internal.ISequenceIdGenerator;
import com.tandbergtv.workflow.driver.template.ITemplateCoderFactory;
import com.tandbergtv.workflow.driver.template.NodeTimeoutGetter;
import com.tandbergtv.workflow.driver.template.NodeTimeoutSetter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.ObjectUtils;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

public class TemplateObjectConvertor {
    private static final Logger logger = Logger.getLogger(TemplateObjectConvertor.class);
    private ISequenceIdGenerator idGenerator;
    private volatile ITemplateCoderFactory coderFactory;

    public TemplateObjectConvertor(ISequenceIdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public WorkflowTemplateDTO toTemplateDTO(WorkflowTemplate template, String jpdlContent, TemplateContentTypeEnum contentType) {
        WorkflowTemplateDTO templateDto = new WorkflowTemplateDTO();
        long templateId = template.getId();
        if (template.isNew()) {
            templateId = this.idGenerator.queryId();
            logger.debug((Object)("Workflow Template ID generated: " + templateId));
        }
        templateDto.setId(templateId);
        templateDto.setName(template.getName());
        templateDto.setVersion(template.getVersion());
        templateDto.setTypeId(WorkflowTemplateTypeId.ACTIVE);
        templateDto.setContentType(contentType);
        templateDto.setProcessDefinition(jpdlContent);
        templateDto.setNodeTimeouts(TemplateObjectConvertor.getTemplateNodeTimeouts(template));
        templateDto.setVariables(TemplateObjectConvertor.getTempalateVariables(template));
        templateDto.setCreateDate(new Date());
        return templateDto;
    }

    private static String getTempalateVariables(WorkflowTemplate template) {
        Collection taskVars = template.getStartTaskVariables();
        HashMap<String, String> dtoVars = new HashMap<String, String>();
        for (TaskVariable taskVar : taskVars) {
            dtoVars.put(taskVar.getVariableName(), taskVar.getInitialValue());
        }
        return JsonObjectMapper.toJsonString(dtoVars);
    }

    private static String getTemplateNodeTimeouts(WorkflowTemplate template) {
        HashMap<String, Object> dtoNodeTimeouts = new HashMap<String, Object>();
        template.greedyBreadthFirstTraversal((NodeVisitor)new NodeTimeoutGetter(dtoNodeTimeouts));
        return JsonObjectMapper.toJsonString(dtoNodeTimeouts);
    }

    public WorkflowTemplate toTemplate(WorkflowTemplateDTO templateDto) {
        if (templateDto == null) {
            return null;
        }
        logger.debug((Object)("Parsing Template DTO content to WorkflowTemplate: " + ObjectUtils.toString((Object)templateDto, (String)" null")));
        WorkflowTemplate template = this.decodeTemplate(templateDto);
        template.setId(templateDto.getId());
        template.setName(templateDto.getName());
        template.setVersion(templateDto.getVersion());
        template.setCreateDate(templateDto.getCreateDate());
        template.setActive(templateDto.isActive());
        try {
            template.setStartTaskVariables(JsonObjectMapper.toMap((String)templateDto.getVariables()));
        }
        catch (TypeConversionException e) {
            logger.error((Object)"error in parsing template variables: ", (Throwable)e);
        }
        String nodeTimeouts = templateDto.getNodeTimeouts();
        logger.debug((Object)("Node Time out Info :" + nodeTimeouts));
        template.greedyBreadthFirstTraversal((NodeVisitor)new NodeTimeoutSetter(templateDto.getNodeTimeoutsMap()));
        return template;
    }

    private WorkflowTemplate decodeTemplate(WorkflowTemplateDTO dto) {
        Assert.notNull((Object)dto.getContentType(), (String)(dto.getFullName() + " Template ContentType should not be null."));
        Assert.notNull((Object)dto.getProcessDefinition(), (String)(dto.getFullName() + " Template Definition should not be null."));
        return this.getTemplateCoderFactory().create(dto.getContentType()).decode(dto.getProcessDefinition());
    }

    private ITemplateCoderFactory getTemplateCoderFactory() {
        if (this.coderFactory == null) {
            this.coderFactory = (ITemplateCoderFactory)ServiceRegistry.getDefault().lookup(ITemplateCoderFactory.class);
        }
        return this.coderFactory;
    }

    public void setCoderFactory(ITemplateCoderFactory coderFactory) {
        this.coderFactory = coderFactory;
    }

    public ISequenceIdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(ISequenceIdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }
}

