/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.driver.internal.monitor.ProcessStatusStatistics;
import com.tandbergtv.workflow.driver.monitor.IProcessMonitor;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.driver.service.ITokenSearchService;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class TokenSearchService
implements ITokenSearchService {
    private SessionFactory factory;
    private static final String SERVICE_NAME = "Token Search Service";

    public TokenSearchService(SessionFactory factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(SearchCriteria criteria) {
        if (criteria == null) {
            throw new IllegalArgumentException("Search criteria must not be null");
        }
        int count = 0;
        try (Session session = null;){
            session = this.factory.openSession();
            Criteria c = this.getBasicCountCriteria((org.hibernate.Session)session);
            c = this.addCriteria(criteria, c);
            c = this.addProcessCriteria(criteria, c);
            count = (Integer)c.uniqueResult();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProcessMonitor statistics(SearchCriteria criteria) {
        if (criteria == null) {
            throw new IllegalArgumentException("Search criteria must not be null");
        }
        ProcessStatusStatistics statistics = null;
        try (Session session = null;){
            session = this.factory.openSession();
            Criteria c = this.getBasicStatisticsCriteria((org.hibernate.Session)session);
            c = this.addCriteria(criteria, c);
            c = this.addProcessCriteria(criteria, c);
            List results = c.list();
            HashMap<ProcessStatus, Integer> data = new HashMap<ProcessStatus, Integer>();
            for (Object row : results) {
                Object[] rowData = (Object[])row;
                ProcessStatus status = (ProcessStatus)rowData[0];
                int count = (Integer)rowData[1];
                data.put(status, count);
            }
            statistics = new ProcessStatusStatistics(data);
        }
        return statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CustomToken> search(SearchCriteria criteria) {
        if (criteria == null) {
            throw new IllegalArgumentException("Search criteria must not be null");
        }
        ArrayList<CustomToken> tokens = new ArrayList();
        try (Session session = null;){
            session = this.factory.openSession();
            Criteria c = this.getBasicCriteria((org.hibernate.Session)session);
            c = this.addCriteria(criteria, c);
            c = this.addProcessCriteria(criteria, c);
            tokens = c.list();
        }
        return tokens;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
    }

    public void stop() {
    }

    private Criteria getBasicCriteria(org.hibernate.Session session) {
        return session.createCriteria(CustomToken.class);
    }

    private Criteria getBasicCountCriteria(org.hibernate.Session session) {
        return this.getBasicCriteria(session).setProjection(Projections.rowCount());
    }

    private Criteria getBasicStatisticsCriteria(org.hibernate.Session session) {
        ProjectionList list = Projections.projectionList();
        list = list.add((Projection)Projections.groupProperty((String)"status")).add(Projections.rowCount());
        return this.getBasicCriteria(session).setProjection((Projection)list);
    }

    private Criteria addCriteria(SearchCriteria criteria, Criteria c) {
        ValueParameter parameter;
        ListParameter list = (ListParameter)criteria.getParameter("tokenstatus", ListParameter.class);
        if (list != null) {
            c.add(Restrictions.in((String)"status", (Collection)list.getValues()));
        }
        if ((parameter = (ValueParameter)criteria.getParameter("child", ValueParameter.class)) != null && Boolean.TRUE.equals(parameter.getValue())) {
            c.add(Restrictions.isNotNull((String)"parent"));
        } else {
            c.add(Restrictions.isNull((String)"parent"));
        }
        return c;
    }

    private Criteria addProcessCriteria(SearchCriteria criteria, Criteria c) {
        ListParameter list;
        c = c.createCriteria("processInstance").add((Criterion)Restrictions.eq((String)"active", (Object)true));
        RangeParameter parameter = (RangeParameter)criteria.getParameter("startTime", RangeParameter.class);
        if (parameter != null) {
            String from = parameter.getFrom();
            try {
                if (from != null) {
                    c.add((Criterion)Restrictions.gt((String)"startTime", (Object)new SimpleDateFormat("yyyy-MM-dd").parse(from)));
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if ((list = (ListParameter)criteria.getParameter("status", ListParameter.class)) != null) {
            c.add(Restrictions.in((String)"status", (Collection)list.getValues()));
        }
        return c.createCriteria("processDefinition").add(Restrictions.sqlRestriction((String)"processDefinitionTypeId=2"));
    }
}

