/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.token;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.InvalidProcessStateException;
import com.tandbergtv.workflow.exe.token.AbstractTokenHandler;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.node.Join;

public class Undo
extends AbstractTokenHandler {
    private static final long serialVersionUID = -3567508677619918147L;
    private static final Logger logger = Logger.getLogger(Undo.class);

    public void execute(ExecutionContext context) throws Exception {
        CustomToken token = (CustomToken)CustomToken.class.cast(context.getToken());
        Node node = context.getNode();
        if (!(node instanceof Join)) {
            return;
        }
        ArrayList<Future<CustomToken>> futures = new ArrayList<Future<CustomToken>>();
        for (CustomToken customToken : token.getChildTokens()) {
            if (!node.equals((Object)customToken.getNode())) continue;
            if (!customToken.hasEnded()) {
                throw new InvalidProcessStateException(customToken.toString());
            }
            futures.add(this.undo(customToken));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                logger.warn((Object)(token + " interrupted while waiting"), (Throwable)e);
            }
            catch (ExecutionException e) {
                logger.warn((Object)(token + ", execution failed"), (Throwable)e);
            }
        }
    }

    private Future<CustomToken> undo(final CustomToken token) {
        return this.getService().getScheduler().schedule((Callable)new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                token.undo();
                return token;
            }
        });
    }
}

