/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.LogLevel;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.graph.IProcessFactory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.DriverRuntimeException;
import com.tandbergtv.workflow.driver.internal.VariableInitializer;
import com.tandbergtv.workflow.driver.monitor.IProcessCounter;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import java.util.Map;
import org.jbpm.graph.def.ProcessDefinition;

public class ProcessFactory
implements IProcessFactory {
    public WorkflowProcess create(ProcessDefinition template, ProcessPriority priority, Map<String, Object> parameters) {
        WorkflowProcess process = null;
        try {
            Map<String, Object> copy = this.getInitialVariables(template, parameters);
            process = new WorkflowProcess(template, priority);
            for (String name : copy.keySet()) {
                process.getContextInstance().setVariable(name, copy.get(name));
            }
            this.postCreate(process);
        }
        catch (DriverException e) {
            throw new DriverRuntimeException(e);
        }
        return process;
    }

    public WorkflowProcess create(CustomToken token, ProcessDefinition template, Map<String, Object> parameters) {
        WorkflowProcess process = null;
        token.getProcessInstance().lock();
        try {
            Map<String, Object> copy = this.getInitialVariables(template, parameters);
            process = token.createSubProcessInstance(template);
            for (String name : copy.keySet()) {
                process.getContextInstance().setVariable(name, copy.get(name));
            }
            this.postCreate(process);
        }
        catch (DriverException e) {
            throw new DriverRuntimeException(ErrorCategory.CHILD_PROCESS_LAUNCH_FAIL.name(), e);
        }
        finally {
            token.getProcessInstance().unlock();
        }
        return process;
    }

    public WorkflowProcess start(CustomToken token, ProcessDefinition template, Map<String, Object> parameters) {
        WorkflowProcess process = this.create(token, template, parameters);
        try {
            this.getService().start(process.getRootToken());
        }
        catch (DriverException e) {
            throw new DriverRuntimeException(e);
        }
        return process;
    }

    protected void postCreate(WorkflowProcess process) {
        process.setLogLevel(this.getLogLevel());
        IPersistenceService service = (IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class);
        service.create(process);
        this.getCounter().created(process.getRootToken());
    }

    protected LogLevel getLogLevel() {
        String level = this.getService().getProperties().getProperty("log.level", LogLevel.ALL.toString());
        return LogLevel.valueOf((String)level.toUpperCase());
    }

    protected IProcessCounter getCounter() {
        return (IProcessCounter)((Object)this.getService().getStatistics().getCumulativeStatistics());
    }

    protected Map<String, Object> getInitialVariables(ProcessDefinition template, Map<String, Object> parameters) throws DriverException {
        return new VariableInitializer(template, parameters).initialize();
    }

    private IProcessManagerService getService() {
        return (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
    }
}

