/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import java.util.Properties;
import org.apache.log4j.Logger;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public class TransportClientFactory {
    private static final Logger LOGGER = Logger.getLogger(TransportClientFactory.class);
    private static final int TRANSPORT_CLIENT_PORT = 9300;

    private TransportClientFactory() {
    }

    public static TransportClient createTransportClient(Properties properties) {
        Settings settings = ImmutableSettings.settingsBuilder().put("cluster.name", properties.getProperty("cluster.name")).build();
        TransportClient client = new TransportClient(settings);
        String hosts = properties.getProperty("hosts");
        String[] names = hosts.split("[,;]");
        if (names == null || names.length == 0) {
            names = new String[]{"es1", "es2"};
        }
        for (String name : names) {
            client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(name, 9300));
            LOGGER.debug((Object)("Host added: " + name + ":" + 9300));
        }
        return client;
    }
}

