/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.DatatypeConverter;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.TypeConversionException;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.driver.DriverException;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.graph.def.ProcessDefinition;

class VariableInitializer {
    private ProcessDefinition template;
    private Map<String, Object> parameters;

    public VariableInitializer(ProcessDefinition template, Map<String, Object> parameters) {
        this.template = template;
        this.parameters = parameters;
    }

    public Map<String, Object> initialize() throws DriverException {
        HashMap<String, Object> copy = new HashMap<String, Object>();
        for (TaskVariable variable : ((WorkflowTemplate)WorkflowTemplate.class.cast(this.template)).getStartTaskVariables()) {
            Object value = this.getValue(variable);
            if (value == null) continue;
            copy.put(variable.getVariableName(), value);
        }
        return copy;
    }

    private Object getValue(TaskVariable variable) throws DriverException {
        String key = variable.getVariableName();
        Object value = this.parameters.get(key);
        if (this.isNullOrEmpty(value)) {
            Object initialValue = this.getInitialValue(variable);
            if (this.isNullOrEmpty(initialValue) && variable.isRequired()) {
                throw new DriverException("Required variable (" + key + ") is not defined");
            }
            return initialValue;
        }
        try {
            return new DatatypeConverter().convert(this.parameters.get(key), variable.getDatatype());
        }
        catch (TypeConversionException e) {
            throw new DriverException("Input value data type mismatch for variable " + key, e);
        }
    }

    private boolean isNullOrEmpty(Object value) {
        return value == null || value instanceof String && ((String)value).trim().length() == 0;
    }

    private Object getInitialValue(TaskVariable variable) {
        Object value = variable.initialValue();
        if (value != null) {
            return value;
        }
        return this.getDefaultValue(variable.getDatatype());
    }

    private Object getDefaultValue(Datatype type) {
        Object value = null;
        switch (type) {
            case STRING: {
                value = "";
                break;
            }
            case BOOLEAN: {
                value = Boolean.FALSE;
                break;
            }
            case INT: {
                value = 0;
                break;
            }
            case FILE: {
                value = "";
                break;
            }
            case URL: {
                value = "";
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }
}

