/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.DatatypeConverter;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.graph.exe.IExecutable;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.exe.ActionException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ExecutionContext;

public abstract class AbstractAction
implements IExecutable {
    private static final long serialVersionUID = 1L;
    private boolean aborted;
    private Future<Void> future;

    public final void abort() {
        this.aborted = true;
        this.future.cancel(true);
    }

    public void cleanup() {
    }

    public final void execute(final ExecutionContext context) throws Exception {
        CustomToken token = (CustomToken)context.getToken();
        if (token.getStatus() == ProcessStatus.ERROR || token.getRequestedStatus() == ProcessStatus.ERROR) {
            if (token.isResumeAfterFail()) {
                throw new ActionException(ErrorCategory.RESOURCE_FAILED.name());
            }
            throw new ActionException(ErrorCategory.TIMEOUT.name());
        }
        ISchedulerService scheduler = (ISchedulerService)ServiceRegistry.getDefault().lookup("message-thread");
        this.future = scheduler.schedule((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AbstractAction.this.start(context);
                return null;
            }
        });
        try {
            this.future.get();
        }
        catch (CancellationException e) {
            if (this.aborted) {
                throw new ActionException(ErrorCategory.TIMEOUT.name(), e);
            }
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ActionException) {
                throw (ActionException)e.getCause();
            }
            throw new ActionException(e.getCause());
        }
    }

    protected abstract void start(ExecutionContext var1);

    protected void setContextVariable(ExecutionContext context, TaskVariable variable, String name, Object value) {
        try {
            if (value == null) {
                context.setVariable(name, value);
            } else {
                context.setVariable(name, new DatatypeConverter().convert(value, variable.getDatatype()));
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)(context.getToken() + ", failed to convert variable " + name + "," + value), (Throwable)e);
        }
    }
}

