/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFToken;
import com.tandbergtv.workflow.core.WFVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WFSearchResult {
    private long processId;
    private String processDefinitionName;
    private String protectionKeys;
    private WFToken token;
    private long rootTokenId;
    private long superProcessTokenId;
    private boolean hasFailedBranch;
    private Map<String, WFVariable> variables = new HashMap<String, WFVariable>();
    private List<WFSearchResult> children = new ArrayList<WFSearchResult>();
    private long searchResultCount;
    private int priority;
    private String isActive;
    private long parentProcessId;

    public WFToken getChildTokenWithId(long id) {
        WFToken retVal;
        block2: {
            WFSearchResult child;
            retVal = null;
            if (this.token != null) {
                retVal = this.token.getChildWithId(id);
            }
            if (retVal != null) break block2;
            Iterator<WFSearchResult> iterator = this.children.iterator();
            while (iterator.hasNext() && (retVal = (child = iterator.next()).getChildTokenWithId(id)) == null) {
            }
        }
        return retVal;
    }

    public WFToken getToken() {
        return this.token;
    }

    public void setToken(WFToken token) {
        this.token = token;
    }

    public List<WFToken> getAllTokens() {
        ArrayList<WFToken> returnVal = new ArrayList<WFToken>();
        returnVal.add(this.token);
        returnVal.addAll(this.token.getAllChildren());
        return returnVal;
    }

    public long getProcessId() {
        return this.processId;
    }

    public void setProcessId(long processId) {
        this.processId = processId;
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    public Map<String, WFVariable> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, WFVariable> variables) {
        this.variables = variables;
    }

    public void addVariable(WFVariable variable) {
        this.variables.put(variable.getName(), variable);
    }

    public void removeVariable(String name) {
        this.variables.remove(name);
    }

    public String getProtectionKeys() {
        return this.protectionKeys;
    }

    public void setProtectionKeys(String protectionKeys) {
        this.protectionKeys = protectionKeys;
    }

    public List<WFSearchResult> getChildren() {
        return this.children;
    }

    public void addChild(WFSearchResult child) {
        this.children.add(child);
    }

    public long getRootTokenId() {
        return this.rootTokenId;
    }

    public void setRootTokenId(long rootTokenId) {
        this.rootTokenId = rootTokenId;
    }

    public long getSearchResultCount() {
        return this.searchResultCount;
    }

    public void setSearchResultCount(long searchResultCount) {
        this.searchResultCount = searchResultCount;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getPriorityStr() {
        return ProcessPriority.values()[this.priority].name();
    }

    public String getIsActive() {
        return this.isActive;
    }

    public void setIsActive(String isActive) {
        this.isActive = isActive;
    }

    public long getSuperProcessTokenId() {
        return this.superProcessTokenId;
    }

    public void setSuperProcessTokenId(long superTokenId) {
        this.superProcessTokenId = superTokenId;
    }

    public boolean isHasFailedBranch() {
        return this.hasFailedBranch;
    }

    public void setHasFailedBranch(boolean hasFailedBranch) {
        this.hasFailedBranch = hasFailedBranch;
    }

    private boolean hasParent() {
        return this.superProcessTokenId != 0L;
    }

    public boolean getCanBeResumed() {
        if (this.hasParent()) {
            return false;
        }
        return this.token.getStatus() == ProcessStatus.PAUSED;
    }

    public boolean getCanBePaused() {
        if (this.hasParent()) {
            return false;
        }
        ProcessStatus status = this.token.getStatus();
        ProcessStatus requestedStatus = this.token.getAdminStatus();
        return status != ProcessStatus.PAUSED && requestedStatus != ProcessStatus.PAUSED && status != ProcessStatus.CANCELLED && requestedStatus != ProcessStatus.CANCELLED && status != ProcessStatus.ERROR && status != ProcessStatus.COMPLETED;
    }

    public boolean getCanBeCancelled() {
        if (this.hasParent()) {
            return false;
        }
        ProcessStatus status = this.token.getStatus();
        ProcessStatus requestedStatus = this.token.getAdminStatus();
        return status != ProcessStatus.CANCELLED && requestedStatus != ProcessStatus.CANCELLED && status != ProcessStatus.COMPLETED;
    }

    public boolean getCanBeRestarted() {
        if (this.hasParent()) {
            return false;
        }
        ProcessStatus status = this.token.getStatus();
        return status == ProcessStatus.COMPLETED || status == ProcessStatus.CANCELLED || status == ProcessStatus.ERROR;
    }

    public boolean getCanBeRetried() {
        ProcessStatus status = this.token.getStatus();
        if (status == ProcessStatus.ERROR && !this.hasParent()) {
            return true;
        }
        return this.isHasFailedBranch();
    }

    public long getParentProcessId() {
        return this.parentProcessId;
    }

    public void setParentProcessId(long parentProcessId) {
        this.parentProcessId = parentProcessId;
    }
}

