/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.event;

import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.resourcemanager.LocalCacheNotReadyException;
import com.tandbergtv.workflow.resourcemanager.internal.IResourceTypeIdAware;
import com.tandbergtv.workflow.resourcemanager.internal.callable.ResourceManagementCallable;
import com.tandbergtv.workflow.resourcemanager.internal.event.IEventHandler;
import com.tandbergtv.workflow.resourcemanager.internal.event.ResourceManagementEventKey;
import org.apache.log4j.Logger;

public abstract class HandleEventCallable
extends ResourceManagementCallable<Void> {
    private static final long serialVersionUID = 455237521753350162L;
    private static final Logger LOGGER = Logger.getLogger(HandleEventCallable.class);
    private WorkflowEvent event;
    private ResourceManagementEventKey eventKey;

    public HandleEventCallable(ResourceManagementEventKey eventKey, WorkflowEvent event) {
        this.eventKey = eventKey;
        this.event = event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void performTask() throws Exception {
        try {
            Long resourceTypeId;
            IEventHandler eventHandler = (IEventHandler)this.getService("ResourceManagementLocalEventHandler");
            IResourceTypeIdAware service = null;
            if (IResourceTypeIdAware.class.isInstance(eventHandler)) {
                service = (IResourceTypeIdAware)IResourceTypeIdAware.class.cast(eventHandler);
            }
            Long l = resourceTypeId = this.eventKey != null ? this.eventKey.getResourceTypeId() : null;
            if (service != null) {
                service.setResourceTypeIdForRequest(resourceTypeId);
            }
            try {
                eventHandler.handleEvent(this.event);
            }
            finally {
                if (service != null) {
                    service.removeResourceTypeIdForRequest();
                }
            }
            return null;
        }
        catch (LocalCacheNotReadyException e) {
            LOGGER.debug((Object)("Failure handling event[" + this.event.getClass().getName() + "]"), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Failure handling event[" + this.event.getClass().getName() + "]"), (Throwable)e);
            throw e;
        }
    }

    public WorkflowEvent getEvent() {
        return this.event;
    }

    public ResourceManagementEventKey getEventKey() {
        return this.eventKey;
    }

    public String toString() {
        return this.event.toString();
    }
}

