/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.pluginmanager.util;

import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.messageidentifier.IMessageIdentifier;
import com.tandbergtv.workflow.pluginmanager.entities.AdaptorDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ManagementDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.MessageDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceTypeDescriptor;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.HeartBeatStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.initialization.InitializationStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class ResourceTypeDescriptorValidator {
    private static final String SYSTEM_ID_REGEX = "\\p{Alnum}{2}";
    private static final String MSG_ID_CLASS = "Message Identification";
    private static final String ADAPTOR_CLASS = "Adaptor";
    private static final String HEARTBEAT_CLASS = "Heartbeat Strategy";
    private static final String INIT_CLASS = "Initialization Strategy";
    private static final Logger LOGGER = Logger.getLogger(ResourceTypeDescriptorValidator.class);

    private ResourceTypeDescriptorValidator() {
    }

    public static List<String> validate(ResourceTypeDescriptor descriptor) {
        ArrayList<String> result = new ArrayList<String>();
        ResourceTypeDescriptorValidator.validateSystemId(descriptor, result);
        ResourceTypeDescriptorValidator.validateName(descriptor, result);
        ResourceTypeDescriptorValidator.validateMessages(descriptor, result);
        ResourceTypeDescriptorValidator.validateAdaptor(descriptor, result);
        ResourceTypeDescriptorValidator.validateManagement(descriptor, result);
        return result;
    }

    private static void validateSystemId(ResourceTypeDescriptor descriptor, List<String> result) {
        String systemId = descriptor.getSystemId();
        if (systemId == null) {
            String msg = "The System Id specified cannot be blank.";
            result.add(msg);
        } else if (!systemId.matches(SYSTEM_ID_REGEX)) {
            String msg = "The System Id specified must be exactly 2 characters, and contain only alphanumeric values.";
            result.add(msg);
        }
    }

    private static void validateName(ResourceTypeDescriptor descriptor, List<String> result) {
        String name = descriptor.getName();
        if (name == null || name.length() == 0) {
            String msg = "The Resource Type Name cannot be blank.";
            result.add(msg);
        }
    }

    private static void validateMessages(ResourceTypeDescriptor descriptor, List<String> result) {
        String systemId = descriptor.getSystemId();
        Map<String, MessageDescriptor> messages = descriptor.getMessages();
        if (messages != null) {
            for (MessageDescriptor message : messages.values()) {
                ResourceTypeDescriptorValidator.validateMessage(systemId, message, result);
            }
        }
    }

    private static void validateMessage(String systemId, MessageDescriptor message, List<String> result) {
        String msg;
        String name = message.getName();
        String uid = message.getUID();
        if (uid == null || uid.length() < 6) {
            String msg2 = "The Message UID: " + uid + " specified for message: " + name + " is invalid.";
            result.add(msg2);
        }
        String srcId = uid.substring(0, 2);
        String destId = uid.substring(2, 4);
        if (!srcId.equals(systemId) && !destId.equals(systemId)) {
            msg = "The Message UID: " + uid + " specified for message: " + name + " doesn't contain the System Id as the message source or destination, and is invalid.";
            result.add(msg);
        }
        if (name == null || name.length() == 0) {
            msg = "The name of the message with UID: " + uid + " cannot be blank.";
            result.add(msg);
        }
    }

    private static void validateAdaptor(ResourceTypeDescriptor descriptor, List<String> result) {
        AdaptorDescriptor adaptor = descriptor.getAdaptor();
        if (adaptor != null) {
            ClassLoader loader = descriptor.getClassLoader();
            if (adaptor.isDefault()) {
                String className = adaptor.getMessageIdentifierClass();
                if (className != null) {
                    Class<IMessageIdentifier> parentClass = IMessageIdentifier.class;
                    ResourceTypeDescriptorValidator.validateClassName(className, loader, parentClass, MSG_ID_CLASS, result);
                }
            } else {
                String className = adaptor.getAdaptorClass();
                Class<IAdaptor> parentClass = IAdaptor.class;
                ResourceTypeDescriptorValidator.validateClassName(className, loader, parentClass, ADAPTOR_CLASS, result);
            }
        }
    }

    private static void validateManagement(ResourceTypeDescriptor descriptor, List<String> result) {
        Class parentClass;
        String className;
        ManagementDescriptor management = descriptor.getManagement();
        ClassLoader loader = descriptor.getClassLoader();
        if (management.getHeartbeatStrategyClass() != null) {
            className = management.getHeartbeatStrategyClass();
            parentClass = HeartBeatStrategy.class;
            ResourceTypeDescriptorValidator.validateClassName(className, loader, parentClass, HEARTBEAT_CLASS, result);
        }
        if (management.getInitializationStrategyClass() != null) {
            className = management.getInitializationStrategyClass();
            parentClass = InitializationStrategy.class;
            ResourceTypeDescriptorValidator.validateClassName(className, loader, parentClass, INIT_CLASS, result);
        }
    }

    private static void validateClassName(String className, ClassLoader loader, Class<?> parentClass, String name, List<String> result) {
        try {
            Class<?> clazz = loader.loadClass(className);
            if (!parentClass.isAssignableFrom(clazz)) {
                String msg = "The " + name + " class: " + className + " does not implement the required interface: " + parentClass.getName();
                result.add(msg);
            }
            clazz.newInstance();
        }
        catch (Throwable ex) {
            String msg = "The " + name + " class: " + className + " cannot be loaded / instantiated.";
            result.add(msg);
            LOGGER.warn((Object)msg, ex);
        }
    }
}

