/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager;

import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceTypeDescriptor;
import com.tandbergtv.workflow.resourcemanager.ResourceContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceGroupContainer;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceTypeDAI;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.event.ResourceTypeCreatedEvent;
import com.tandbergtv.workflow.resourcemanager.internal.ICloneService;
import com.tandbergtv.workflow.resourcemanager.internal.IHibernatePersistenceService;
import com.tandbergtv.workflow.resourcemanager.internal.container.BaseContainer;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;

public class ResourceTypeContainer
extends BaseContainer<ResourceType> {
    private static final long serialVersionUID = -7492495888713366646L;
    private static final Logger LOGGER = Logger.getLogger(ResourceTypeContainer.class);

    public ResourceTypeContainer(ResourceType resourceType) {
        super(resourceType);
    }

    public String toString() {
        return "resource type" + ((ResourceType)this.getEntity()).toString();
    }

    @Override
    public Serializable getKey() {
        return Long.valueOf(((ResourceType)this.getEntity()).getId());
    }

    @Override
    public Long getResourceTypeId() {
        return ((ResourceType)this.getEntity()).getId();
    }

    @Override
    protected void doStart() {
        if (((ResourceType)this.getEntity()).isSendCreatedEvent()) {
            ((ResourceType)this.getEntity()).setSendCreatedEvent(false);
            ICloneService service = this.getService(ICloneService.class);
            ResourceType clone = service.cloneResourceType((ResourceType)this.getEntity());
            DefaultMediator.getInstance().sendAsync((WorkflowEvent)new ResourceTypeCreatedEvent(clone));
            this.updateEntity();
        }
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void writeToDistributedCache() {
        IDistributedCache cache = (IDistributedCache)this.getService("WFS:ResourceTypeCache");
        Long key = ((ResourceType)this.getEntity()).getId();
        ICloneService cloneService = this.getService(ICloneService.class);
        cache.add((Serializable)key, (Object)cloneService.cloneResourceType((ResourceType)this.getEntity()));
    }

    @Override
    protected void writeToPersistenceStore() {
        IHibernatePersistenceService service = this.getService(IHibernatePersistenceService.class);
        SessionFactory factory = service.getSessionFactory();
        Session session = factory.getCurrentSession();
        ResourceTypeDAI dao = service.getDataAccessObjectFactory().getResourceTypeDAO();
        ResourceType clone = this.getService(ICloneService.class).cloneResourceType((ResourceType)this.getEntity());
        service.beginTransaction((org.hibernate.Session)session);
        try {
            dao.update(clone);
            service.commitTransaction((org.hibernate.Session)session);
        }
        catch (RuntimeException ex) {
            service.rollbackTransaction((org.hibernate.Session)session);
            String msg = "Failed to internally update ResourceType[id=" + this.getKey() + "]: " + ((ResourceType)this.getEntity()).getName() + ", the object in memory is different from the DB.";
            LOGGER.error((Object)msg, (Throwable)ex);
        }
    }

    public void performMaintenance(ResourceTypeDescriptor descriptor, ResourceType resourceType) {
        ((ResourceType)this.getEntity()).setName(resourceType.getName());
        ((ResourceType)this.getEntity()).setConnectionType(resourceType.getConnectionType());
        ((ResourceType)this.getEntity()).setHeartbeatConnectionType(resourceType.getHeartbeatConnectionType());
        ((ResourceType)this.getEntity()).setNotLicensed(resourceType.isNotLicensed());
        ((ResourceType)this.getEntity()).setPluginMissing(resourceType.isPluginMissing());
        this.updateEntity();
        ICacheService cache = (ICacheService)this.getService("ResourceContainerCache");
        long resourceTypeId = this.getResourceTypeId();
        for (Serializable key : cache.getKeys()) {
            ResourceContainer container = (ResourceContainer)cache.get(key);
            if (container == null || container.isStopped() || resourceTypeId != container.getResourceTypeId()) continue;
            container.getWriteLock().lock();
            try {
                if (container.isStopped()) continue;
                container.performMaintenance(descriptor);
            }
            finally {
                container.getWriteLock().unlock();
            }
        }
        ICacheService groupCache = (ICacheService)this.getService("ResourceGroupContainerCache");
        for (Serializable key : groupCache.getKeys()) {
            ResourceGroupContainer container = (ResourceGroupContainer)groupCache.get(key);
            if (container == null || container.isStopped() || resourceTypeId != container.getResourceTypeId()) continue;
            container.getWriteLock().lock();
            try {
                if (container.isStopped()) continue;
                container.performMaintenance(descriptor);
            }
            finally {
                container.getWriteLock().unlock();
            }
        }
    }
}

