/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.util;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.internal.IResourceManagementInternal;
import org.apache.log4j.Logger;

public class ResourceFailureLogWriter {
    private static final String LOG_FORMAT = "application-metrics.workflow.%s.%s.Failure 1 %d";
    private static final Logger LOGGER = Logger.getLogger(ResourceFailureLogWriter.class);
    private static ResourceFailureLogWriter instance = ResourceFailureLogWriter.getInstance();

    public static ResourceFailureLogWriter getInstance() {
        if (instance == null) {
            instance = new ResourceFailureLogWriter();
        }
        return instance;
    }

    protected ResourceFailureLogWriter() {
    }

    public void writeLog(long resourceGroupId, Resource resource) {
        try {
            long timestamp = this.getTimestamp();
            IResourceManagementInternal service = this.getResourceManager();
            ResourceGroup group = service.getResourceGroup(resourceGroupId);
            this.getOutputLogger().warn((Object)String.format(LOG_FORMAT, "resource_group_failure", group.getName(), timestamp));
            String resourceName = "";
            resourceName = resource == null ? "No Resource - " + group.getName() : (resource.getId() == -1L ? "Internal Resource - " + group.getName() : resource.getName());
            this.getOutputLogger().warn((Object)String.format(LOG_FORMAT, "resource_failure", resourceName, timestamp));
        }
        catch (Throwable t) {
            this.getOutputLogger().warn((Object)"Problem while writing resource failure logs", t);
        }
    }

    protected Logger getOutputLogger() {
        return LOGGER;
    }

    protected IResourceManagementInternal getResourceManager() {
        return (IResourceManagementInternal)ServiceRegistry.getDefault().lookup(IResourceManagementInternal.class);
    }

    protected long getTimestamp() {
        return System.currentTimeMillis();
    }
}

