/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.internal;

import com.hazelcast.config.MapConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.MultiMap;
import com.tandbergtv.workflow.core.service.cache.IMultiValueCacheService;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class DistributedMultiValueCache<T>
implements IMultiValueCacheService<T> {
    private String name;
    private MultiMap<Serializable, T> map;
    private static final Logger LOGGER = Logger.getLogger(DistributedMultiValueCache.class);

    public DistributedMultiValueCache(String name) {
        this(name, Integer.MAX_VALUE);
    }

    public DistributedMultiValueCache(String name, int size) {
        this.name = name;
        MapConfig config = new MapConfig(name);
        config.getMaxSizeConfig().setSize(size);
        config.setEvictionPolicy("LRU");
        Hazelcast.getConfig().addMapConfig(config);
    }

    @Override
    public String getServiceName() {
        return this.name;
    }

    @Override
    public void start() {
        this.map = Hazelcast.getMultiMap((String)this.name);
    }

    @Override
    public void stop() {
        this.map = null;
    }

    @Override
    public Collection<T> get(Serializable key) {
        HashSet filteredValues = new HashSet();
        Collection cachedValues = this.map.get((Object)key);
        if (cachedValues != null) {
            for (Object value : cachedValues) {
                if (filteredValues.contains(value)) {
                    filteredValues.remove(value);
                }
                filteredValues.add(value);
            }
        }
        return filteredValues;
    }

    @Override
    public Set<Serializable> getKeys() {
        return this.map.keySet();
    }

    @Override
    public Collection<T> getValues() {
        return this.map.values();
    }

    @Override
    public boolean add(Serializable key, T value) {
        T oldValue = this.findEqualValue(key, value);
        boolean result = this.map.put((Object)key, value);
        if (result && oldValue != null) {
            this.removeExistingValue(key, oldValue);
        }
        return result || oldValue != null;
    }

    @Override
    public boolean remove(Serializable key, T value) {
        T oldValue = this.findEqualValue(key, value);
        if (oldValue != null) {
            return this.removeExistingValue(key, oldValue);
        }
        return false;
    }

    private T findEqualValue(Serializable key, T value) {
        Collection values = this.map.get((Object)key);
        if (values != null) {
            for (Object oldValue : values) {
                if (!oldValue.equals(value)) continue;
                return (T)oldValue;
            }
        }
        return null;
    }

    private boolean removeExistingValue(Serializable key, T existingValue) {
        boolean removed = this.map.remove((Object)key, existingValue);
        if (!removed) {
            LOGGER.warn((Object)("Multi-Value Cache[" + this.getServiceName() + "]: Failed to remove existing value " + existingValue), new Throwable());
        }
        return removed;
    }

    @Override
    public Collection<T> remove(Serializable key) {
        return this.map.remove((Object)key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int count() {
        return this.map.size();
    }

    @Override
    public int valueCount(Serializable key) {
        return this.map.valueCount((Object)key);
    }

    @Override
    public boolean containsKey(Serializable key) {
        return this.map.containsKey((Object)key);
    }

    @Override
    public boolean containsValue(T value) {
        return this.map.containsValue(value);
    }

    @Override
    public boolean containsEntry(Serializable key, T value) {
        return this.map.containsEntry((Object)key, value);
    }
}

