/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.thread;

import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cluster.IClusterService;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;

public abstract class SingleThreadPeriodicService
implements Service,
Runnable {
    private static final long DEFAULT_DELAY = 0L;
    private static final long DEFAULT_INTERVAL = 900000L;
    private long delay = 0L;
    private long interval = 900000L;
    private ISchedulerService schedulerService;
    private IClusterService clusterService;

    @Override
    public void start() {
        this.getSchedulerService().start();
        this.getSchedulerService().schedule(this, this.delay, this.interval);
        this.init();
    }

    @Override
    public void stop() {
        this.destroy();
        this.getSchedulerService().stop();
    }

    @Override
    public void run() {
        if (this.getClusterService().isMaster()) {
            this.execute();
        }
    }

    private ISchedulerService getSchedulerService() {
        if (this.schedulerService == null) {
            this.schedulerService = new Scheduler(this.getThreadName(), 1, 1);
        }
        return this.schedulerService;
    }

    protected void setSchedulerService(ISchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    protected IClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = ServiceRegistry.getDefault().lookup(IClusterService.class);
        }
        return this.clusterService;
    }

    protected void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public abstract String getThreadName();

    protected abstract void init();

    protected abstract void destroy();

    protected abstract void execute();
}

