/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.test.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import sun.misc.BASE64Encoder;

public class RestClient {
    private String userPasswordEncoding;
    private long lastModifiedDate;
    private int responseCode;
    private HashMap<String, String> customHeader = new HashMap();
    private String responseFormat;
    private String eTag;
    private String location;

    public RestClient(String userName, String password) {
        this.userPasswordEncoding = new BASE64Encoder().encode((userName + ":" + password).getBytes());
        this.setResponseFormat("application/json");
    }

    public String getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(String responseFormat) {
        this.responseFormat = responseFormat;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public HashMap<String, String> getCustomHeader() {
        return this.customHeader;
    }

    public void setCustomHeader(HashMap<String, String> customHeader) {
        this.customHeader = customHeader;
    }

    public String postRestRequest(String urlStr, String postRequest) throws Exception {
        return this.sendRest(urlStr, "POST", postRequest);
    }

    public String getRestRequest(String urlStr) throws Exception {
        return this.sendRest(urlStr, "GET", "");
    }

    public String deleteRestRequest(String urlStr) throws Exception {
        return this.sendRest(urlStr, "DELETE", "");
    }

    public String updateRestRequest(String urlStr, String postRequest) throws Exception {
        return this.sendRest(urlStr, "PUT", postRequest);
    }

    public String sendRest(String urlStr, String requestType, String postRequest) throws Exception {
        javax.net.ssl.TrustManager[] trustAllCerts = new TrustManager[]{new TrustManager()};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        StringBuilder sb = new StringBuilder();
        HttpURLConnection con = null;
        try {
            URL url = new URL(urlStr);
            con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("Authorization", "Basic " + this.userPasswordEncoding);
            con.setDoOutput(true);
            con.setRequestMethod(requestType);
            if (!requestType.equals("DELETE")) {
                con.setRequestProperty("Accept", this.responseFormat);
            }
            con.setRequestProperty("Content-Type", "application/xml");
            if (!this.customHeader.isEmpty()) {
                for (Map.Entry<String, String> customHeaderParams : this.customHeader.entrySet()) {
                    con.setRequestProperty(customHeaderParams.getKey(), customHeaderParams.getValue());
                }
            }
            if (requestType.equals("POST") || requestType.equals("PUT")) {
                int bytesRead;
                ByteArrayInputStream is = new ByteArrayInputStream(postRequest.getBytes());
                OutputStream output = con.getOutputStream();
                byte[] buffer = new byte[4096];
                while ((bytesRead = is.read(buffer)) != -1) {
                    output.write(buffer, 0, bytesRead);
                }
                output.flush();
                ((InputStream)is).close();
            }
            this.responseCode = con.getResponseCode();
            this.lastModifiedDate = con.getLastModified();
            if (con.getHeaderField("Etag") != null) {
                this.eTag = con.getHeaderField("Etag");
            }
            if (con.getHeaderField("Location") != null) {
                this.location = con.getHeaderField("Location");
            }
            if (con.getResponseCode() == 200 || con.getResponseCode() == 202 && requestType != "DELETE") {
                BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    line = br.readLine();
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            con.disconnect();
        }
        return sb.toString();
    }

    public String geteTag() {
        return this.eTag;
    }

    public void seteTag(String eTag) {
        this.eTag = eTag;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    private class TrustManager
    implements X509TrustManager {
        private TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

