/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.unit.test;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.util.resource.InternalResourceService;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ServiceRegistry.class})
public class InternalResourceServiceUnitTest {
    private static ServiceRegistry registry;
    private static ResourceManagement resourceManagement;
    private static Collection<String> systemIds;
    private static InternalResourceService internalResourceService;
    private static int RG_ALLOCATABLE_TRUE;
    private static int RG_ALLOCATABLE_FALSE;
    private static int RG1_RESOURCETYPE_ALLOCATION_DISABLED;
    private static int RG2_RESOURCETYPE_ALLOCATION_DISABLED;
    private static int RG_DOES_NOT_EXIST;
    private static String SYSTEM_ID;

    @BeforeClass
    public static void setup() throws Exception {
        registry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        PowerMockito.mockStatic(ServiceRegistry.class, (Class[])new Class[0]);
        Mockito.when((Object)ServiceRegistry.getDefault()).thenReturn((Object)registry);
        resourceManagement = (ResourceManagement)PowerMockito.mock(ResourceManagement.class);
        Mockito.when((Object)registry.lookup(ResourceManagement.class)).thenReturn((Object)resourceManagement);
        ArrayList<ResourceGroup> groupsByType = new ArrayList<ResourceGroup>();
        groupsByType.add(InternalResourceServiceUnitTest.getGroup1ByType());
        groupsByType.add(InternalResourceServiceUnitTest.getGroup2ByType());
        Mockito.when((Object)resourceManagement.getResourceTypeBySystemId(SYSTEM_ID)).thenReturn((Object)InternalResourceServiceUnitTest.getAllocationDisabledResourceType());
        Mockito.when((Object)resourceManagement.getResourceGroupsByResourceType(1L)).thenReturn(groupsByType);
        ArrayList<ResourceGroup> groups = new ArrayList<ResourceGroup>();
        groups.add(InternalResourceServiceUnitTest.getIsAllocatableResourceGroup());
        groups.add(InternalResourceServiceUnitTest.getNonAllocatableResourceGroup());
        Mockito.when((Object)resourceManagement.getAllResourceGroups()).thenReturn(groups);
        systemIds.add(SYSTEM_ID);
        internalResourceService = new InternalResourceService(systemIds);
        internalResourceService.start();
    }

    @AfterClass
    public static void cleanup() {
        internalResourceService.stop();
    }

    @Test
    public void testNeedsResourceWhenResourceTypeHasAllocationDisabled() throws Exception {
        Assert.assertFalse((boolean)internalResourceService.needsResource((long)RG1_RESOURCETYPE_ALLOCATION_DISABLED));
        Assert.assertFalse((boolean)internalResourceService.needsResource((long)RG2_RESOURCETYPE_ALLOCATION_DISABLED));
        Assert.assertTrue((boolean)internalResourceService.needsResource((long)RG_DOES_NOT_EXIST));
    }

    @Test
    public void testNeedsResourceWhenGroupIsAllocatable() throws Exception {
        Assert.assertTrue((boolean)internalResourceService.needsResource((long)RG_ALLOCATABLE_TRUE));
    }

    @Test
    public void testNeedsResourceWhenGroupIsNotAllocatable() throws Exception {
        Assert.assertFalse((boolean)internalResourceService.needsResource((long)RG_ALLOCATABLE_FALSE));
    }

    @Test
    public void testNeedsResourceWhenAddIsCalled() throws Exception {
        internalResourceService.add(5L);
        Assert.assertFalse((boolean)internalResourceService.needsResource(5L));
        Assert.assertTrue((boolean)internalResourceService.needsResource((long)RG_ALLOCATABLE_TRUE));
        Assert.assertFalse((boolean)internalResourceService.needsResource((long)RG_ALLOCATABLE_FALSE));
        Assert.assertFalse((boolean)internalResourceService.needsResource((long)RG1_RESOURCETYPE_ALLOCATION_DISABLED));
        Assert.assertFalse((boolean)internalResourceService.needsResource((long)RG2_RESOURCETYPE_ALLOCATION_DISABLED));
        Assert.assertTrue((boolean)internalResourceService.needsResource((long)RG_DOES_NOT_EXIST));
    }

    @Test
    public void testNeedsResourceWhenRemoveIsCalled() throws Exception {
        internalResourceService.add(7L);
        Assert.assertFalse((boolean)internalResourceService.needsResource(7L));
        internalResourceService.remove(7L);
        Assert.assertTrue((boolean)internalResourceService.needsResource(7L));
        Assert.assertTrue((boolean)internalResourceService.needsResource((long)RG_ALLOCATABLE_TRUE));
        Assert.assertFalse((boolean)internalResourceService.needsResource((long)RG_ALLOCATABLE_FALSE));
        Assert.assertFalse((boolean)internalResourceService.needsResource((long)RG1_RESOURCETYPE_ALLOCATION_DISABLED));
        Assert.assertFalse((boolean)internalResourceService.needsResource((long)RG2_RESOURCETYPE_ALLOCATION_DISABLED));
        Assert.assertTrue((boolean)internalResourceService.needsResource((long)RG_DOES_NOT_EXIST));
    }

    private static ResourceType getAllocationDisabledResourceType() {
        ResourceType resourceType = new ResourceType();
        resourceType.setSystemId(SYSTEM_ID);
        resourceType.setName("Allocation Disabled");
        resourceType.setId(1L);
        return resourceType;
    }

    private static ResourceGroup getIsAllocatableResourceGroup() {
        ResourceGroup group = new ResourceGroup((long)RG_ALLOCATABLE_TRUE);
        group.setAllocatable(true);
        group.setName("Allocatable Group");
        return group;
    }

    private static ResourceGroup getNonAllocatableResourceGroup() {
        ResourceGroup group = new ResourceGroup((long)RG_ALLOCATABLE_FALSE);
        group.setAllocatable(false);
        group.setName("Non Allocatable Group");
        return group;
    }

    private static ResourceGroup getGroup1ByType() {
        ResourceGroup group = new ResourceGroup((long)RG1_RESOURCETYPE_ALLOCATION_DISABLED);
        group.setName("Group1 Assoicated with SystemId" + SYSTEM_ID);
        return group;
    }

    private static ResourceGroup getGroup2ByType() {
        ResourceGroup group = new ResourceGroup((long)RG2_RESOURCETYPE_ALLOCATION_DISABLED);
        group.setName("Group2 Assoicated with SystemId" + SYSTEM_ID);
        return group;
    }

    static {
        systemIds = new ArrayList<String>();
        RG_ALLOCATABLE_TRUE = 1;
        RG_ALLOCATABLE_FALSE = 2;
        RG1_RESOURCETYPE_ALLOCATION_DISABLED = 3;
        RG2_RESOURCETYPE_ALLOCATION_DISABLED = 4;
        RG_DOES_NOT_EXIST = 6;
        SYSTEM_ID = "4";
    }
}

