/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.nodetype.loop.test;

import com.google.common.collect.Lists;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.test.NormalTestBase;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.testng.annotations.Test;

public class LoopVerifyNodeTypes
extends NormalTestBase {
    private static final String LIST_VARIABLE_NAME = "manualVariableList";
    private static final String ASSIGN_VARIABLE_NAME = "loopManualVariable";

    @Test
    public void testLoopWithSubprocess() throws Exception {
        WorkflowProcess wp = this.run("loop-subprocess-template");
        long id = wp.getId();
        long timeout = 6L;
        LoopVerifyNodeTypes.assertTrue((boolean)ProcessUtils.sleepUntilComplete(id, 5000L + timeout * 2L * 1000L));
    }

    @Test
    public void testLoopWithSubprocess2() throws Exception {
        WorkflowProcess wp = this.run("loop-subprocess-with-loop-template");
        long id = wp.getId();
        LoopVerifyNodeTypes.assertTrue((boolean)ProcessUtils.sleepUntilComplete(id, 60000L));
    }

    @Test
    public void testSuperstateInLoop() throws Exception {
        WorkflowProcess wp = this.run("loop-superstate-template");
        long id = wp.getId();
        LoopVerifyNodeTypes.assertTrue((boolean)ProcessUtils.sleepUntilComplete(id, 60000L));
    }

    @Test
    public void testLoopInSuperstate() throws Exception {
        WorkflowProcess wp = this.run("loop-in-superstate-template");
        long id = wp.getId();
        LoopVerifyNodeTypes.assertTrue((boolean)ProcessUtils.sleepUntilComplete(id, 60000L));
    }

    @Test
    public void testLoopComboTemplate() throws Exception {
        WorkflowProcess wp = this.run("loop-combo-template");
        long id = wp.getId();
        ProcessUtils.sleepUntilStatus(id, 60000L, ProcessStatus.ERROR);
        wp = ProcessUtils.get(id);
        LoopVerifyNodeTypes.assertEquals((int)ProcessUtils.getIntegerVariable(wp, "decision"), (int)3);
        LoopVerifyNodeTypes.assertEquals((String)ProcessUtils.getStringVariable(wp, "decision_result"), (String)"right");
        LoopVerifyNodeTypes.assertEquals((int)ProcessUtils.getIntegerVariable(wp, "left_branch_counter"), (int)4);
        LoopVerifyNodeTypes.assertEquals((int)ProcessUtils.getIntegerVariable(wp, "right_branch_counter"), (int)4);
        LoopVerifyNodeTypes.assertEquals((int)ProcessUtils.getIntegerVariable(wp, "counter"), (int)1);
        LoopVerifyNodeTypes.assertEquals((Object)wp.getRootToken().getStatus(), (Object)ProcessStatus.ERROR);
    }

    @Test
    public void testLoopManualTaskTemplate() throws Exception {
        Map<String, Object> params = this.getParameters();
        WorkflowProcess wp = this.run("loop-manual-task-template", params);
        long id = wp.getId();
        int count = ((Collection)params.get(LIST_VARIABLE_NAME)).size();
        List<Object> listVariable = ProcessUtils.getListVariable(wp, LIST_VARIABLE_NAME);
        for (int i = 0; i < count; ++i) {
            LoopVerifyNodeTypes.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 60000L, ProcessStatus.BUSY));
            Thread.sleep(5000L);
            wp = ProcessUtils.get(id);
            TaskInstance task = ProcessUtils.getTaskInstance(wp);
            LoopVerifyNodeTypes.assertNotNull((Object)task);
            LoopVerifyNodeTypes.assertEquals((String)ProcessUtils.getStringVariable(wp, ASSIGN_VARIABLE_NAME), (String)listVariable.get(i).toString());
            ProcessUtils.performManualTask(wp);
        }
        LoopVerifyNodeTypes.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 60000L, ProcessStatus.COMPLETED));
    }

    Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(LIST_VARIABLE_NAME, new ArrayList(Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4"})));
        return params;
    }
}

