/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.process.test;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.test.NormalTestBase;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import java.util.HashMap;
import org.testng.annotations.Test;

public class CancelPauseTest
extends NormalTestBase {
    private static final String First_NODE = "node1";
    private static final String SECOND_NODE = "node2";

    @Test(enabled=false)
    void testPause() throws Exception {
        this.doOperation(ProcessStatus.PAUSED);
    }

    @Test(enabled=false)
    void testCancel() throws Exception {
        this.doOperation(ProcessStatus.CANCELLED);
    }

    void doOperation(ProcessStatus status) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        WorkflowProcess process = this.run("four-node-template", params);
        long processId = process.getId();
        ProcessUtils.sleepUntilStatus(processId, 5000L, ProcessStatus.BUSY);
        Thread.sleep(1000L);
        CancelPauseTest.assertEquals((String)ProcessUtils.get(processId).getRootToken().getCurrentNode().getName(), (String)First_NODE);
        if (status == ProcessStatus.PAUSED) {
            this.getService().pause(process.getRootToken());
        } else {
            this.getService().cancel(process.getRootToken());
        }
        CancelPauseTest.assertTrue((boolean)ProcessUtils.sleepUntilStatus(processId, 15000L, status));
        CancelPauseTest.assertEquals((String)ProcessUtils.get(processId).getRootToken().getCurrentNode().getName(), (String)SECOND_NODE);
    }

    IProcessManagerService getService() {
        return (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
    }
}

