/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.template.test;

import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.test.NormalTestBase;
import com.tandbergtv.workflow.test.util.TestUtil;
import java.io.File;
import java.util.ArrayList;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TaskVariableParsingTest
extends NormalTestBase {
    private static final String TEMPLATE_NO_PROVIDERID = "titleId-required-template";
    private static final String TEMPLATE_NONREQUIRED_PROVIDERID = "titleId-providerId-template";

    @AfterClass
    private void deleteTemplates() throws Exception {
        ArrayList<String> templates = new ArrayList<String>();
        templates.add(TEMPLATE_NONREQUIRED_PROVIDERID);
        templates.add(TEMPLATE_NO_PROVIDERID);
        for (String templateName : templates) {
            WorkflowTemplate template = this.getService().getTemplateByName(templateName);
            if (template != null) {
                this.getService().delete(template);
            }
            TaskVariableParsingTest.assertNull((Object)this.getService().getTemplateByName(templateName));
        }
    }

    @Test
    public void testProviderIdVariableIsMarkedAsRequired() throws Exception {
        TestUtil.deploy(new File("resources/template/titleId-providerId-template.par"));
        Thread.sleep(15000L);
        WorkflowTemplate template = this.getService().getTemplateByName(TEMPLATE_NONREQUIRED_PROVIDERID);
        TaskVariableParsingTest.assertNotNull((Object)template);
        for (TaskVariable variable : template.getStartTaskVariables()) {
            if (!variable.getVariableName().equals("providerId")) continue;
            TaskVariableParsingTest.assertTrue((boolean)variable.isRequired(), (String)"providerId variable is not set to required");
        }
    }

    @Test
    public void testTemplateWithNoProviderIdVariable() throws Exception {
        TestUtil.deploy(new File("resources/template/titleId-required-template.par"));
        Thread.sleep(15000L);
        WorkflowTemplate template = this.getService().getTemplateByName(TEMPLATE_NO_PROVIDERID);
        TaskVariableParsingTest.assertNotNull((Object)template);
        boolean isFound = false;
        for (TaskVariable variable : template.getStartTaskVariables()) {
            if (!variable.getVariableName().equals("providerId")) continue;
            isFound = true;
            TaskVariableParsingTest.assertTrue((boolean)variable.isRequired(), (String)"providerId variable is not set to required");
        }
        TaskVariableParsingTest.assertTrue((boolean)isFound, (String)"providerId variable was not added to the template");
    }

    private ITemplateLoaderService getService() {
        return TestUtil.getService(ITemplateLoaderService.class);
    }
}

