/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.test.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.DataOperationException;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceManagementException;
import com.tandbergtv.workflow.resourcemanager.ValidationException;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.test.util.ResourceBuilder;
import java.util.Collection;
import java.util.List;

public class ResourceUtils {
    private ResourceUtils() {
    }

    public static Resource getResource(long id) throws ResourceManagementException {
        return ResourceUtils.getService().getResource(id);
    }

    public static List<ResourceGroup> getResourceGroupsByResourceType(long id) {
        return ResourceUtils.getService().getResourceGroupsByResourceType(id);
    }

    public static void setResourceOffline(long id) throws ResourceManagementException {
        ResourceUtils.getService().setResourceOffline(id);
    }

    public static void setResourceOnline(long id) throws ResourceManagementException {
        ResourceUtils.getService().setResourceOnline(id);
    }

    public static int getResourceUserCount(long id) throws ResourceManagementException {
        return ResourceUtils.getResource(id).getUserCount();
    }

    public static ResourceBuilder getResourceBuilderFromSystemId(String resourceTypeSystemId, String prefix) {
        Resource exampleResource = (Resource)ResourceUtils.getService().getResourcesBySystemId(resourceTypeSystemId).get(0);
        return new ResourceBuilder(exampleResource, prefix);
    }

    public static ResourceBuilder getResourceBuilderFromSystemId(String resourceTypeSystemId) {
        return ResourceUtils.getResourceBuilderFromSystemId(resourceTypeSystemId, "");
    }

    public static Resource createResource(ResourceBuilder builder) throws DataOperationException, ValidationException {
        Resource resource = builder.build();
        return ResourceUtils.getService().createResource(resource);
    }

    public static void deleteResourcesWithPrefix(String resourceTypeSystemId, String prefix) throws ResourceManagementException {
        for (Resource resource : ResourceUtils.getResourcesWithPrefix(resourceTypeSystemId, prefix)) {
            ResourceUtils.setResourceOffline(resource.getId());
            if (ResourceUtils.getService().getResourceByConnectionString(resource.getConnectionString()).getOperationalState() != ResourceState.OFFLINE) {
                throw new IllegalStateException("Resource " + resource.getName() + " would not go offline for cleanup.");
            }
            ResourceUtils.getService().deleteResource(resource.getId());
            if (ResourceUtils.getService().getResourceByConnectionString(resource.getConnectionString()) == null) continue;
            throw new IllegalStateException("Resource " + resource.getName() + "did not get deleted.");
        }
    }

    public static void setResourcesOffline(String resourceSystemId) throws ResourceManagementException {
        ResourceManagement resourceManagement = ResourceUtils.getService();
        for (Resource r : resourceManagement.getResourcesBySystemId(resourceSystemId)) {
            resourceManagement.setResourceOffline(r.getId());
        }
    }

    public static void setResourcesOnline(String resourceSystemId) throws ResourceManagementException {
        ResourceManagement resourceManagement = ResourceUtils.getService();
        for (Resource r : resourceManagement.getResourcesBySystemId(resourceSystemId)) {
            resourceManagement.setResourceOnline(r.getId());
        }
    }

    private static ResourceManagement getService() {
        return (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
    }

    public static List<ResourceGroup> getResourceGroupsByResourceTypeSystemId(String systemId) {
        ResourceType type = ResourceUtils.getService().getResourceTypeBySystemId(systemId);
        return ResourceUtils.getResourceGroupsByResourceType(type.getId());
    }

    public static Collection<Resource> getResourcesWithPrefix(String resourceTypeSystemId, final String prefix) {
        Collection filtered = Collections2.filter((Collection)ResourceUtils.getService().getResourcesBySystemId(resourceTypeSystemId), (Predicate)new Predicate<Resource>(){

            public boolean apply(Resource r) {
                return r.getName().startsWith(prefix);
            }
        });
        return filtered;
    }
}

