/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.process.create;

import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.driver.DriverRuntimeException;
import com.tandbergtv.workflow.test.NormalTestBase;
import java.util.ArrayList;
import java.util.HashMap;
import org.testng.annotations.Test;

public class TestRequiredListTypeVariable
extends NormalTestBase {
    private static final String PARAM_LIST = "paramList";
    private static final String TEMPLATE = "list-parameter-required-template";

    @Test(expectedExceptions={DriverRuntimeException.class})
    public void testCreateProcessWithoutRequiredListParameter() throws Exception {
        this.run(TEMPLATE);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testCreateProcessWithEmptyElementInRequiredListTypeVaraible() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> l = new ArrayList<String>();
        l.add("");
        params.put(PARAM_LIST, l);
        this.run(TEMPLATE, params);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testCreateProcessWithOneEmptyElementInRequiredListTypeVariable() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> l = new ArrayList<String>();
        l.add("1");
        l.add("");
        l.add("2");
        params.put(PARAM_LIST, l);
        this.run(TEMPLATE, params);
    }

    @Test
    public void testCreateProcessWithSpecialCharsInListTypeVariable() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> l = new ArrayList<String>();
        l.add("$#$%^$&%(^*");
        params.put(PARAM_LIST, l);
        WorkflowProcess wp = this.run(TEMPLATE, params);
        TestRequiredListTypeVariable.assertEquals(l, (Object)wp.getContextInstance().getVariable(PARAM_LIST));
    }
}

