/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resource.test;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.test.SequentialTestBase;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import com.tandbergtv.workflow.test.util.ResourceUtils;
import com.tandbergtv.workflow.test.util.TestUtil;
import java.util.HashMap;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class MessageTimeout
extends SequentialTestBase {
    ResourceManagement resourceManager;
    String resourceName = "MessageTimeout";
    String connectionString = "http://localhost:246813579";
    int concurrency = 1;
    boolean ignoreTimeout = false;
    ResourceState adminState = ResourceState.ONLINE;

    @BeforeClass
    public void setup() throws Exception {
        this.resourceManager = TestUtil.getResourceManagement();
        ResourceUtils.setResourcesOffline("ut");
        for (Resource leftoverResource : this.resourceManager.getResourcesBySystemId("ut")) {
            if (!leftoverResource.getName().contains(this.resourceName)) continue;
            this.resourceManager.deleteResource(leftoverResource.getId());
        }
        Resource resource = this.setNewResourceParameters();
        this.resourceManager.createResource(resource);
    }

    @AfterClass
    private void teardown() throws Exception {
        Resource resource = this.refreshResource();
        this.resourceManager.setResourceOffline(resource.getId());
        this.resourceManager.deleteResource(resource.getId());
        ResourceUtils.setResourcesOnline("ut");
    }

    @Test(enabled=false)
    public void errorOnTimeout() throws Exception {
        this.setIgnoreTimeout(false);
        WorkflowProcess wp = this.run("exception-timeout-template", new HashMap<String, Object>());
        long id = wp.getId();
        ProcessUtils.sleepUntilStatus(id, 10000L, ProcessStatus.ERROR);
        Thread.sleep(500L);
        boolean resourceError = this.isResourceInError();
        MessageTimeout.assertTrue((boolean)resourceError);
    }

    @Test
    public void ignoreTimeoutCheckbox() throws Exception {
        this.setIgnoreTimeout(true);
        WorkflowProcess wp = this.run("exception-timeout-template", new HashMap<String, Object>());
        long id = wp.getId();
        ProcessUtils.sleepUntilStatus(id, 10000L, ProcessStatus.ERROR);
        Thread.sleep(1000L);
        boolean resourceError = this.isResourceInError();
        MessageTimeout.assertFalse((boolean)resourceError);
    }

    private void setIgnoreTimeout(boolean value) throws Exception {
        Resource resource = this.refreshResource();
        resource.setIgnoreTimeout(value);
        this.resourceManager.setResourceOffline(resource.getId());
        this.resourceManager.updateResource(resource);
        this.resourceManager.setResourceOnline(resource.getId());
        Thread.sleep(500L);
    }

    private boolean isResourceInError() {
        Resource resource = this.refreshResource();
        return resource.getOperationalState() == ResourceState.ERROR;
    }

    private Resource setNewResourceParameters() {
        Resource exampleResource = (Resource)this.resourceManager.getResourcesBySystemId("ut").get(0);
        Resource resource = new Resource();
        resource.setResourceType(exampleResource.getResourceType());
        resource.setResourceGroups(exampleResource.getResourceGroups());
        resource.setName(this.resourceName);
        resource.setConnectionString(this.connectionString);
        resource.setHeartbeatConnectionString(null);
        resource.setHeartbeatFrequency(null);
        resource.setMaxConcurrentUsers(this.concurrency);
        resource.setIgnoreTimeout(this.ignoreTimeout);
        resource.setAdministrationState(this.adminState);
        return resource;
    }

    private Resource refreshResource() {
        return this.resourceManager.getResourceByConnectionString(this.connectionString);
    }
}

