/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.test;

import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.IProcessFactory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.template.ITemplateService;
import com.tandbergtv.workflow.log.WorkflowLogService;
import com.tandbergtv.workflow.log.entities.MessageLog;
import com.tandbergtv.workflow.log.entities.ProcessStatusPerResourceLog;
import com.tandbergtv.workflow.log.entities.WorkflowMessageLog;
import com.tandbergtv.workflow.log.file.LogReader;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.test.WorkflowTestBase;
import com.tandbergtv.workflow.test.util.ESTransportClient;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import com.tandbergtv.workflow.test.util.TestUtil;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.elasticsearch.client.transport.TransportClient;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.logging.log.ProcessLog;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

@Test(groups={"sequential"})
public class CMS65516Test
extends WorkflowTestBase {
    private static final int WAIT_FOR_ELASTICSEARCH = 20;
    private static final String DEFAULT_TEMPLATE = "loop-call-resource-template";
    private TransportClient client;
    private WorkflowLogService wflService;
    private LogReader logReader;

    @BeforeClass
    protected void setup() throws Exception {
        this.client = ESTransportClient.getTransportClient();
        this.wflService = (WorkflowLogService)ServiceRegistry.getDefault().lookup(WorkflowLogService.class);
        this.logReader = new LogReader(this.client);
    }

    @Test
    public void testHistoryLogsOnFilesystem() throws Exception {
        this.createWorkOrders(1, false);
        ResourceManagement resourceManagement = TestUtil.getResourceManagement();
        for (Resource r : resourceManagement.getResourcesBySystemId("27")) {
            System.out.println("Setting Resource " + r.getName() + " Offline for CMS65516Test. AdminState:" + r.getAdministrationState() + ", OpState:" + r.getOperationalState() + ". User Info:" + r.getUserName() + ", userCount:" + r.getUserCount());
            resourceManagement.setResourceOffline(r.getId());
        }
        for (WorkflowProcess wp : this.getCreatedProcesses()) {
            ProcessUtils.getProcessManager().start(ProcessUtils.get(wp.getId()).getRootToken());
        }
        TimeUnit.SECONDS.sleep(20L);
        for (WorkflowProcess wp : this.getCreatedProcesses()) {
            int totalNodeLogs = this.wflService.getNodeLogCount(wp.getProcessDefinition(), wp.getId());
            int totalMessageLogs = this.logReader.getLogs(wp.getId(), MessageLog.class).size();
            int totalResourceLogs = this.logReader.getLogs(wp.getId(), ProcessStatusPerResourceLog.class).size();
            CMS65516Test.assertEquals((int)(totalNodeLogs + totalMessageLogs + totalResourceLogs), (int)2);
            CMS65516Test.assertEquals((int)totalNodeLogs, (int)2);
        }
        for (Resource r : resourceManagement.getResourcesBySystemId("27")) {
            System.out.println("Setting Resource " + r.getName() + " Online for CMS65516Test. AdminState:" + r.getAdministrationState() + ", OpState:" + r.getOperationalState() + ". User Info:" + r.getUserName() + ", userCount:" + r.getUserCount());
            resourceManagement.setResourceOnline(r.getId());
        }
        ProcessUtils.sleepUntilStatus(((WorkflowProcess)this.createdProcesses.iterator().next()).getId(), 60000L, ProcessStatus.COMPLETED);
        TimeUnit.SECONDS.sleep(20L);
        for (WorkflowProcess wp : this.getCreatedProcesses()) {
            this.assertLogsCorrectForCompletedDefaultTemplate(wp.getProcessDefinition(), wp.getId());
        }
    }

    private void assertLogsCorrectForCompletedDefaultTemplate(WorkflowTemplate defaultTemplate, long id) throws Exception {
        System.out.println("Inspecting logs for WO id " + id);
        Thread.sleep(10000L);
        List nodeLogs = this.wflService.findNodeLogs(defaultTemplate, id, 0, 10);
        CMS65516Test.assertEquals((int)nodeLogs.size(), (int)9);
        List<ProcessStatusPerResourceLog> statusPerResourceLogs = this.getstatusPerResourceLogs(id);
        CMS65516Test.assertEquals((int)statusPerResourceLogs.size(), (int)8);
        for (int i = 0; i < 4; i += 2) {
            CMS65516Test.assertEquals((Object)statusPerResourceLogs.get(i).getOperationalStatus(), (Object)ProcessStatus.QUEUED);
            CMS65516Test.assertEquals((Object)statusPerResourceLogs.get(i + 1).getOperationalStatus(), (Object)ProcessStatus.RUNNING);
        }
        List<MessageLog> messageLogs = this.getMessageLogs(id);
        CMS65516Test.assertEquals((int)messageLogs.size(), (int)8);
        for (MessageLog ml : messageLogs) {
            WorkflowMessageLog wml = ml.getLog();
            WorkflowMessage wfm = this.getWorkflowMessage(wml);
            if (!wml.isIncoming()) {
                CMS65516Test.assertEquals((String)wml.getMessageName(), (String)"Echo");
                CMS65516Test.assertEquals((String)wml.getMessageType(), (String)"control");
                continue;
            }
            CMS65516Test.assertEquals((String)wml.getMessageName(), (String)"Echo");
            CMS65516Test.assertEquals((String)wml.getMessageType(), (String)"ack");
        }
    }

    private List<ProcessStatusPerResourceLog> getstatusPerResourceLogs(long id) throws Exception {
        List statusProcessLogs = this.logReader.getLogs(id, ProcessStatusPerResourceLog.class);
        ArrayList<ProcessStatusPerResourceLog> processStatusPerResourceLogs = new ArrayList<ProcessStatusPerResourceLog>();
        for (ProcessLog log : statusProcessLogs) {
            processStatusPerResourceLogs.add((ProcessStatusPerResourceLog)log);
        }
        return processStatusPerResourceLogs;
    }

    private List<MessageLog> getMessageLogs(long id) throws Exception {
        List messageProcessLogs = this.logReader.getLogs(id, MessageLog.class);
        ArrayList<MessageLog> messageLogs = new ArrayList<MessageLog>();
        for (ProcessLog log : messageProcessLogs) {
            messageLogs.add((MessageLog)log);
        }
        return messageLogs;
    }

    private WorkflowMessage getWorkflowMessage(WorkflowMessageLog wml) throws Exception {
        String message = wml.getMessage();
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(message));
        inputSource.setCharacterStream(new StringReader(message));
        Document doc = documentBuilder.parse(inputSource);
        return Unmarshaller.unmarshal((Document)doc);
    }

    private void createWorkOrders(int numWOs, boolean start) throws Exception {
        for (int i = 0; i < numWOs; ++i) {
            this.createWorkOrder(DEFAULT_TEMPLATE, start);
        }
    }

    private WorkflowProcess createWorkOrder(String templateName, boolean start) throws Exception {
        WorkflowTemplate template = TestUtil.getService(ITemplateService.class).getTemplateByName(templateName);
        IProcessFactory factory = (IProcessFactory)JbpmConfiguration.Configs.getObject((String)"jbpm.process.factory");
        WorkflowProcess wp = factory.create((ProcessDefinition)template, ProcessPriority.P10, new HashMap());
        this.getCreatedProcesses().add(ProcessUtils.get(wp.getId()));
        if (start) {
            ProcessUtils.getProcessManager().start(wp.getRootToken());
        }
        return wp;
    }
}

