/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.watchfolder.core;

import com.tandbergtv.watchpoint.watchfolder.core.DirectoryMonitor;
import com.tandbergtv.watchpoint.watchfolder.core.FileInfo;
import com.tandbergtv.watchpoint.watchfolder.core.Processor;
import com.tandbergtv.watchpoint.watchfolder.core.WPFileFilter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LocalDirectoryMonitor
extends DirectoryMonitor {
    private static final Logger logger = Logger.getLogger(LocalDirectoryMonitor.class);
    String path;

    public LocalDirectoryMonitor(String path, Set<WPFileFilter> fileFilters, Processor processor) {
        super(fileFilters, processor);
        this.path = path;
        logger.debug((Object)("Local Directory Monitor constructor called | path: " + path));
    }

    @Override
    protected Map<String, FileInfo> getFiles() throws IOException {
        logger.debug((Object)"Local Directory Monitor's getFiles()");
        HashMap<String, FileInfo> files = new HashMap<String, FileInfo>();
        File directory = new File(this.path);
        if (!directory.exists()) {
            logger.warn((Object)("Directory with path: " + this.path + " does not exist"));
            return files;
        }
        File[] list = directory.listFiles();
        if (list == null) {
            throw new IOException("Failed to get list of files for directory " + directory.getAbsolutePath());
        }
        for (File file : list) {
            files.put(file.getName(), this.getFileInfo(file));
        }
        return files;
    }

    private FileInfo getFileInfo(File file) {
        return new FileInfo(file.getName(), file.length(), file.lastModified(), file.getAbsolutePath());
    }
}

