/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.watchfolder.core;

import java.util.regex.Pattern;

public class WPFileFilter {
    private String filter;
    private static final String DEFAULT_FILTER = "";

    public WPFileFilter() {
        this.filter = DEFAULT_FILTER;
    }

    public WPFileFilter(String filter) {
        if (filter == null) {
            filter = DEFAULT_FILTER;
        } else {
            this.filter = filter.toLowerCase();
        }
    }

    public boolean accept(String fileName) {
        if (DEFAULT_FILTER.equals(this.filter)) {
            return true;
        }
        return Pattern.matches(this.filter, fileName.toLowerCase());
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String toString() {
        return "(" + this.filter + ")";
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof WPFileFilter) {
            return this.getFilter().equals((WPFileFilter)obj);
        }
        return false;
    }

    public int hashCode() {
        return this.filter.hashCode();
    }
}

