/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.watchfolder.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.tools.tar.n2.TarEntry;
import org.apache.tools.tar.n2.TarInputStream;

public class TarUtil {
    private static final Logger logger = Logger.getLogger(TarUtil.class);
    private static TarUtil _instance = null;

    private TarUtil() {
    }

    public static synchronized TarUtil getInstance() {
        if (_instance == null) {
            _instance = new TarUtil();
        }
        return _instance;
    }

    public String[] list(String filePath) {
        File file = new File(filePath);
        ArrayList<String> names = new ArrayList<String>();
        TarInputStream in = null;
        TarEntry te = null;
        try {
            in = new TarInputStream((InputStream)new FileInputStream(file));
            in.setFastScan(true);
            in.setDebug(false);
            while ((te = in.getNextEntry()) != null) {
                logger.debug((Object)("File " + te.getName()));
                names.add(te.getName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
        return names.toArray(new String[0]);
    }

    public void unpack(String filePath, String outputDirectory) {
        logger.debug((Object)("Extracting " + filePath + " to " + outputDirectory));
        TarInputStream in = null;
        TarEntry te = null;
        try {
            in = new TarInputStream((InputStream)new FileInputStream(new File(filePath)));
            in.setFastScan(true);
            in.setDebug(false);
            while ((te = in.getNextEntry()) != null) {
                this.extract(in, outputDirectory, te.getName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extract(TarInputStream in, String dir, String file) throws IOException {
        logger.debug((Object)("File " + file));
        File f = new File(dir, file);
        FileOutputStream fos = null;
        try {
            f.getParentFile().mkdirs();
            fos = new FileOutputStream(f);
            in.copyEntryContents((OutputStream)fos);
            fos.flush();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public InputStream getInputStream(String filePath, String name) throws FileNotFoundException {
        logger.debug((Object)("File path " + filePath));
        File file = new File(filePath);
        TarInputStream in = null;
        TarEntry te = null;
        try {
            in = new TarInputStream((InputStream)new FileInputStream(file));
            in.setFastScan(true);
            in.setDebug(false);
            while ((te = in.getNextEntry()) != null) {
                if (!name.equals(te.getName())) continue;
                logger.debug((Object)("File " + te.getName()));
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                in.copyEntryContents((OutputStream)os);
                ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                os.close();
                ByteArrayInputStream byteArrayInputStream = is;
                return byteArrayInputStream;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
        return null;
    }
}

