/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.watchfolder.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public class VersionProvider {
    private static VersionProvider provider = null;
    private static final String VERSION_FILE = "/version.properties";
    private static String version = "";
    private static Logger logger = Logger.getLogger(VersionProvider.class);

    public static VersionProvider getInstance() {
        if (provider == null) {
            provider = new VersionProvider();
        }
        return provider;
    }

    private VersionProvider() {
        InputStream inStream = this.getClass().getResourceAsStream(VERSION_FILE);
        String contents = null;
        try {
            contents = VersionProvider.readStreamContents(inStream);
        }
        catch (Exception ex) {
            logger.warn((Object)"Failed to read WatchFolder version file: /version.properties");
        }
        version = contents != null ? contents.trim() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readStreamContents(InputStream inStream) throws IOException {
        BufferedReader reader = null;
        String contents = null;
        try {
            reader = new BufferedReader(new InputStreamReader(inStream));
            contents = VersionProvider.readContents(reader);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                logger.warn((Object)"Failed to close stream being read.", (Throwable)ex);
            }
        }
        return contents;
    }

    private static String readContents(BufferedReader reader) throws IOException {
        StringBuffer messageBuffer = new StringBuffer();
        String line = null;
        while ((line = reader.readLine()) != null) {
            messageBuffer.append(line);
            messageBuffer.append(System.getProperty("line.separator"));
        }
        return messageBuffer.toString();
    }

    public String getVersion() {
        return version;
    }
}

