/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.handler;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.AbstractHandler;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XportPackagerCallbackHandler
extends AbstractHandler {
    private final String XPORT_PACKAGER_RESPONSE = "XPORT_PACKAGER_RESPONSE_PARAMETER";
    private final String XPORT_PACKAGER_FAILURE_STRING = "XPORT_PACKAGER_RESPONSE_VALUE";
    private final String WPCL_COMMAND = "COMMAND";
    private static Logger logger = Logger.getLogger(XportPackagerCallbackHandler.class);

    public XportPackagerCallbackHandler() {
    }

    public XportPackagerCallbackHandler(IHandlerConfiguration conf) {
        super(conf);
    }

    public IMessage process(IMessage msg) throws HandlerException {
        HTTPMessage result = null;
        try {
            Document document = XMLDocumentUtility.loadXml((String)msg.getPayload().getContent());
            WorkflowMessage message = Unmarshaller.unmarshal((Document)document);
            String command = this.getConfiguration().getParameterValue("COMMAND");
            message.setCommand(new WPCLCommand(command));
            String responseParameter = this.getConfiguration().getParameterValue("XPORT_PACKAGER_RESPONSE_PARAMETER");
            String responseValue = this.getConfiguration().getParameterValue("XPORT_PACKAGER_RESPONSE_VALUE");
            logger.info((Object)("Response parameter read = " + responseParameter));
            if (message.getValue(responseParameter).equalsIgnoreCase(responseValue)) {
                message.setType(WorkflowMessage.MessageType.nack);
            }
            document = Marshaller.newMarshaller().marshal(message);
            HTTPPayload payload = new HTTPPayload(XMLDocumentUtility.convertToString((Node)document));
            result = new HTTPMessage(payload);
        }
        catch (Exception ex) {
            throw new HandlerException((Throwable)ex);
        }
        return result;
    }

    public IMessage postProcess(IMessage msg) throws HandlerException {
        return msg;
    }
}

