/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.handler;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.AbstractHandler;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPortEncodeCompleteTransformer
extends AbstractHandler {
    private static final String XPORT_SUCCESS_FLAG = "Success";
    private static final String ERROR_MESSAGE_KEY_SENT_BY_XPORT = "ErrorMessage";

    public XPortEncodeCompleteTransformer() {
    }

    public XPortEncodeCompleteTransformer(IHandlerConfiguration conf) {
        super(conf);
    }

    public IMessage process(IMessage msg) throws HandlerException {
        HTTPMessage result = null;
        try {
            WorkflowPayload wpclPayload;
            Document document = XMLDocumentUtility.loadXml((String)msg.getPayload().getContent());
            WorkflowMessage message = Unmarshaller.unmarshal((Document)document);
            message.setCommand(new WPCLCommand("task-complete"));
            if (!Boolean.valueOf(message.getValue(XPORT_SUCCESS_FLAG)).booleanValue()) {
                message.setType(WorkflowMessage.MessageType.nack);
            }
            if ((wpclPayload = message.getPayload()).containsKey(ERROR_MESSAGE_KEY_SENT_BY_XPORT)) {
                String errorMessage = wpclPayload.getValue(ERROR_MESSAGE_KEY_SENT_BY_XPORT);
                wpclPayload.putValue("error-message", errorMessage);
                wpclPayload.remove(ERROR_MESSAGE_KEY_SENT_BY_XPORT);
            }
            document = Marshaller.newMarshaller().marshal(message);
            HTTPPayload payload = new HTTPPayload(XMLDocumentUtility.convertToString((Node)document));
            result = new HTTPMessage(payload);
        }
        catch (Exception e) {
            throw new HandlerException((Throwable)e);
        }
        return result;
    }

    public IMessage postProcess(IMessage msg) throws HandlerException {
        return msg;
    }
}

