/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.plugins.directv.adaptor;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.AbstractHandler;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.TCPMessage;
import com.tandbergtv.workflow.message.TCPPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.message.util.MarshalException;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import com.tandbergtv.workflow.plugins.directv.adaptor.VTPSResponseConstants;
import com.tandbergtv.workflow.plugins.directv.adaptor.VTPSResponseMessageConstants;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VTPSStatusHandler
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger(VTPSStatusHandler.class);
    private static final String UPDATE_TEMPLATE_FILE_PATH = "UpdateTemplateFilePath";
    private static final String COMPLETE_TEMPLATE_FILE_PATH = "CompleteTemplateFilePath";
    private static final String ERROR_TEMPLATE_FILE_PATH = "ErrorTemplateFilePath";
    private static final String MATERIAL_ID_XPATH = "MaterialIdXPath";
    private static final String STATUS_XPATH = "StatusXPath";
    private static final String ERROR_MESSAGE_XPATH = "ErrorMessageXPath";
    private static final String UID_XPATH = "UIDXPath";

    public VTPSStatusHandler() {
    }

    public VTPSStatusHandler(IHandlerConfiguration conf) {
        super(conf);
    }

    public IMessage process(IMessage msg) throws HandlerException {
        TCPMessage result = null;
        logger.debug((Object)("Input: " + msg));
        try {
            String msgContent = msg.getPayload().getContent();
            WorkflowMessage wfsMessage = Unmarshaller.unmarshal((Document)XMLDocumentUtility.loadXml((String)msgContent));
            String msgUID = wfsMessage.getMessageUID().getUID();
            WorkflowPayload workflowPayload = wfsMessage.getPayload();
            String messageString = workflowPayload.getValue(VTPSResponseMessageConstants.CONTENT.toString());
            if (messageString == null || messageString.length() < 3) {
                String errMsg = "The VTPS Message must have at least 3 characters (containing the Message Code). Invalid Message received: " + messageString;
                throw new HandlerException(errMsg);
            }
            String parseString = messageString;
            int messageCode = -1;
            try {
                messageCode = Integer.parseInt(parseString.substring(0, 3));
                parseString = parseString.substring(3);
            }
            catch (NumberFormatException nfe) {
                String errMsg = "Failed to read a valid Message Code (integer value) from the incoming VTPS Message: " + messageString;
                throw new HandlerException(errMsg, (Throwable)nfe);
            }
            int indexOfPipe = parseString.indexOf("|");
            int indexOfColon = parseString.indexOf(":");
            if (indexOfPipe == -1 || indexOfColon == -1 || indexOfPipe > indexOfColon) {
                String errMsg = "Failed to read the Material Id from the incoming VTPS message (expected between characters '|' and ':'): " + messageString;
                throw new HandlerException(errMsg);
            }
            String materialId = parseString.substring(indexOfPipe + 1, indexOfColon).trim();
            parseString = parseString.substring(indexOfColon + 1);
            Document document = null;
            XPath xPath = XPathFactory.newInstance().newXPath();
            document = VTPSResponseConstants.PERCENTAGE_COMPLETE.isWithinRange(messageCode) ? this.processSuccessMessage(messageString, parseString, msgUID, xPath) : this.processFailureMessage(messageString, parseString, msgUID, xPath);
            String materialIdXPath = this.getConfiguration().getParameterValue(MATERIAL_ID_XPATH);
            XMLDocumentUtility.setNodeValue((String)materialIdXPath, (String)materialId, (XPath)xPath, (Node)document);
            String uidXPath = this.getConfiguration().getParameterValue(UID_XPATH);
            String messageUIDString = XMLDocumentUtility.getNodeValue((String)uidXPath, (XPath)xPath, (Node)document);
            logger.debug((Object)("Parsed UID: " + messageUIDString));
            Marshaller marshaller = Marshaller.newMarshaller();
            Element sourceElement = marshaller.createSourceElement(document, wfsMessage.getSource());
            if (sourceElement != null) {
                document.getDocumentElement().appendChild(sourceElement);
            }
            String outMessageContent = XMLDocumentUtility.convertToString((Node)document);
            result = new TCPMessage(new TCPPayload(outMessageContent));
            logger.debug((Object)("Output: " + msg));
        }
        catch (MarshalException me) {
            String errMsg = "Could not unmarshal message to work WorkflowMessage when Workflow Message was expected. Message: " + msg;
            throw new HandlerException(errMsg, (Throwable)me);
        }
        catch (HandlerException he) {
            throw he;
        }
        catch (Exception e) {
            throw new HandlerException("Failed to process message: " + msg, (Throwable)e);
        }
        return result;
    }

    private Document processSuccessMessage(String completeMessage, String content, String messageUID, XPath xpath) throws Exception {
        Document result = null;
        int endIndex = content.indexOf("% Complete.");
        int percentComplete = 0;
        try {
            if (endIndex != -1) {
                String percentValue = content.substring(0, endIndex).trim();
                percentComplete = Integer.parseInt(percentValue);
            }
        }
        catch (NumberFormatException ex) {
            String errMsg = "Failed to parse the Percent Complete value in VTPS message: " + completeMessage;
            throw new HandlerException(errMsg, (Throwable)ex);
        }
        String templateName = null;
        if (percentComplete == 100) {
            templateName = this.getConfiguration().getParameterValue(COMPLETE_TEMPLATE_FILE_PATH);
            result = this.getTemplate(messageUID, templateName);
        } else {
            templateName = this.getConfiguration().getParameterValue(UPDATE_TEMPLATE_FILE_PATH);
            result = this.getTemplate(messageUID, templateName);
            String statusXPath = this.getConfiguration().getParameterValue(STATUS_XPATH);
            String value = Integer.toString(percentComplete);
            XMLDocumentUtility.setNodeValue((String)statusXPath, (String)value, (XPath)xpath, (Node)result);
        }
        return result;
    }

    private Document processFailureMessage(String completeMessage, String content, String messageUID, XPath xpath) throws Exception {
        Document result = null;
        String templateName = this.getConfiguration().getParameterValue(ERROR_TEMPLATE_FILE_PATH);
        result = this.getTemplate(messageUID, templateName);
        String errorMessage = content.trim();
        String errorXPath = this.getConfiguration().getParameterValue(ERROR_MESSAGE_XPATH);
        XMLDocumentUtility.setNodeValue((String)errorXPath, (String)errorMessage, (XPath)xpath, (Node)result);
        return result;
    }

    private Document getTemplate(String messageUID, String templateName) throws Exception {
        String templatePath = "adaptor/" + messageUID + "/" + templateName;
        logger.debug((Object)("template path: " + templatePath));
        return XMLDocumentUtility.loadFile((ClassLoader)this.getConfiguration().getClassLoader(), (String)templatePath);
    }

    public IMessage postProcess(IMessage msg) throws HandlerException {
        logger.debug((Object)"returning message as it is  from postProcess");
        return msg;
    }
}

