/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.pmm.client.uiservices;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.pmm.client.IScheduleService;
import com.tandbergtv.cms.pmm.client.IScheduleServiceAsync;
import com.tandbergtv.cms.pmm.client.i18n.ContentConstants;
import com.tandbergtv.cms.pmm.client.uiservices.AddTitleResult;
import com.tandbergtv.cms.pmm.client.uiservices.ScheduleException;
import com.tandbergtv.cms.pmm.client.uiservices.TitleScheduleValidation;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.TitleActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.List;

public class AddTitlesToSchedule
implements ITitleService {
    private ContentConstants displayConstants = (ContentConstants)GWT.create(ContentConstants.class);

    public void execute(final List<Long> titleIds, String serviceParameter, IActionInput input, final AsyncCallback<IOperationResult> callback) {
        final TitleActionInput actionInput = (TitleActionInput)input;
        if (actionInput.getScheduleId() == 0L) {
            callback.onFailure((Throwable)new RuntimeException(this.displayConstants.scheduleRequiredFailure()));
            return;
        }
        IScheduleServiceAsync service = (IScheduleServiceAsync)GWT.create(IScheduleService.class);
        service.addTitlesToSchedule(actionInput.getScheduleId(), titleIds, (AsyncCallback<?>)new NeptuneAsyncCallback<Boolean>(){

            public void onNeptuneFailure(Throwable caught) {
                if (caught instanceof TitleScheduleValidation) {
                    AddTitlesToSchedule.this.setScheduleValidationErrorMessage(caught);
                } else if (caught instanceof ScheduleException) {
                    AddTitlesToSchedule.this.setScheduleErrorMessage(caught);
                }
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(Boolean result) {
                callback.onSuccess((Object)new AddTitleResult(this.prepareSuccessMessage(), actionInput.getScheduleId(), actionInput.getSpec()));
            }

            private String prepareSuccessMessage() {
                StringBuilder sb = new StringBuilder();
                for (Long id : titleIds) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(id);
                }
                return String.valueOf(AddTitlesToSchedule.this.displayConstants.addTitlesServiceSuccess0()) + sb.toString() + AddTitlesToSchedule.this.displayConstants.addTitlesServiceSuccess1() + actionInput.getScheduleId();
            }
        });
    }

    private void setScheduleValidationErrorMessage(Throwable caught) {
        TitleScheduleValidation exception = (TitleScheduleValidation)((Object)caught);
        StringBuilder sb = new StringBuilder();
        for (String code : exception.getErrorCodes()) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(this.displayConstants.getString(code));
        }
        exception.setMessage(String.valueOf(this.displayConstants.addTitlesServiceScheduleFailure()) + sb.toString());
    }

    private void setScheduleErrorMessage(Throwable caught) {
        ScheduleException exception = (ScheduleException)((Object)caught);
        exception.setMessage(String.valueOf(this.displayConstants.addTitlesServiceScheduleFailure()) + this.displayConstants.getString(exception.getErrorCode()));
    }

    public String getDescription() {
        return this.displayConstants.addTitlesServiceDescription();
    }

    public String getName() {
        return this.displayConstants.addTitlesServiceName();
    }

    public void gotoResultPage(IOperationResult result, IView sourceView) {
        History.newItem((String)("PMM.Schedule.View?scheduleId=" + ((AddTitleResult)result).getScheduleId() + "&spec=" + ((AddTitleResult)result).getSpec()));
    }

    public void getServiceParameters(NeptuneAsyncCallback<List<String>> callback) {
        callback.onSuccess(null);
    }

    public boolean getConfirmation() {
        return false;
    }

    public boolean isSelected(ViewInput inputData) {
        return inputData.getScheduleId() != 0L;
    }
}

