/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.contentmgmt.ejb.titlelist;

import com.tandbergtv.cms.contentmgmt.service.template.IWorkOrderRequestSender;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.comm.routing.RoutingServiceFactory;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;

@Stateless
public class TitleListWorkOrderRequestSender
implements IWorkOrderRequestSender {
    private String TITLELISTID = "titleListId";
    private String TEMPLATE_NAME = "_template";
    private String MESSAGE_UID = "CM0104";
    private String COMMAND_NAME = "create";

    @RolesAllowed(value={"WorkOrderManagement_Create"})
    public void sendWorkOrderCreateMessage(long titleId, String templateName) {
        try {
            this.sendMessage(titleId, templateName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void sendMessage(long id, String templateName) throws Exception {
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)this.MESSAGE_UID);
        WPCLCommand command = new WPCLCommand(this.COMMAND_NAME);
        command.addParameter(this.TEMPLATE_NAME, templateName);
        message.setCommand(command);
        message.getPayload().putValue(this.TITLELISTID, String.valueOf(id));
        IRoutingService router = RoutingServiceFactory.newInstance().createRoutingService();
        router.send(new WPCLConverter().convert(message));
    }
}

