/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.services.title;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.rpc.title.AssociatedToTitleListUIException;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleDeleteService;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleDeleteServiceAsync;
import com.tandbergtv.cms.portal.content.client.services.title.DeleteResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.List;

public class DeleteService
implements ITitleService {
    private ContentConstants displayConstants = (ContentConstants)GWT.create(ContentConstants.class);

    public void execute(final List<Long> titleIds, String serviceParameter, IActionInput input, final AsyncCallback<IOperationResult> callback) {
        final ITitleDeleteServiceAsync service = (ITitleDeleteServiceAsync)GWT.create(ITitleDeleteService.class);
        service.delete(titleIds, false, (AsyncCallback<?>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                if (caught instanceof AssociatedToTitleListUIException) {
                    DeleteService.this.confirmWithUser(new Runnable(){

                        @Override
                        public void run() {
                            service.delete(titleIds, true, (AsyncCallback<?>)new NeptuneAsyncCallback<Void>(){

                                public void onNeptuneFailure(Throwable caught) {
                                    DeleteService.this.handleServiceFailure(titleIds, (AsyncCallback<IOperationResult>)callback, caught);
                                }

                                public void onNeptuneSuccess(Void result) {
                                    DeleteService.this.handleServiceSuccess(titleIds, (AsyncCallback<IOperationResult>)callback);
                                }
                            });
                        }
                    }, new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess((Object)new DeleteResult(DeleteService.this.displayConstants.deleteServiceUserAbort()));
                        }
                    });
                } else {
                    DeleteService.this.handleServiceFailure(titleIds, (AsyncCallback<IOperationResult>)callback, caught);
                }
            }

            public void onNeptuneSuccess(Void result) {
                DeleteService.this.handleServiceSuccess(titleIds, (AsyncCallback<IOperationResult>)callback);
            }
        });
    }

    private void handleServiceSuccess(List<Long> titleIds, AsyncCallback<IOperationResult> callback) {
        callback.onSuccess((Object)new DeleteResult(String.valueOf(this.displayConstants.deleteServiceSuccess()) + " " + this.getTitleIdsList(titleIds)));
    }

    private void handleServiceFailure(List<Long> titleIds, AsyncCallback<IOperationResult> callback, Throwable caught) {
        String errorMsg = String.valueOf(this.displayConstants.deleteServiceFailure()) + this.getTitleIdsList(titleIds) + " " + caught.getLocalizedMessage();
        callback.onFailure((Throwable)new NeptuneException(errorMsg));
    }

    private void confirmWithUser(final Runnable yes, final Runnable no) {
        final PopupContainer confirmation = new PopupContainer(false, true);
        VerticalContainer popContainer = new VerticalContainer();
        popContainer.add((Widget)new LabelWidget(this.displayConstants.deleteServiceConfirmTLAssociation()));
        HorizontalContainer buttonContainer = new HorizontalContainer();
        ButtonWidget yesButton = new ButtonWidget(this.displayConstants.confirmationYes());
        yesButton.addStyleDependentName("commit-button");
        yesButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                confirmation.hide();
                yes.run();
            }
        });
        buttonContainer.add((Widget)yesButton);
        ButtonWidget noButton = new ButtonWidget(this.displayConstants.confirmationNo());
        noButton.addStyleDependentName("dataloss-button");
        noButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                confirmation.hide();
                no.run();
            }
        });
        buttonContainer.add((Widget)noButton);
        popContainer.add((Widget)buttonContainer);
        popContainer.setCellHorizontalAlignment((Widget)buttonContainer, VerticalContainer.ALIGN_CENTER);
        confirmation.add((Widget)popContainer);
        confirmation.center();
        confirmation.show();
    }

    private String getTitleIdsList(List<Long> titleIds) {
        StringBuilder deletedIds = new StringBuilder();
        for (long id : titleIds) {
            if (deletedIds.length() > 0) {
                deletedIds.append(", ");
            }
            deletedIds.append(id);
        }
        return deletedIds.toString();
    }

    public String getDescription() {
        return this.displayConstants.deleteServiceDescription();
    }

    public String getName() {
        return this.displayConstants.deleteServiceName();
    }

    public void gotoResultPage(IOperationResult result, IView sourceView) {
        sourceView.refresh(result.getMessage());
    }

    public void getServiceParameters(NeptuneAsyncCallback<List<String>> callback) {
        callback.onSuccess(null);
    }

    public boolean getConfirmation() {
        return true;
    }

    public boolean isSelected(ViewInput inputData) {
        return inputData.getScheduleId() == 0L && inputData.getTitleListId() == 0L;
    }
}

